/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.python;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.python.PythonScriptEngineFactory;
import org.python.util.PythonInterpreter;

public class PythonScriptEngine
extends AbstractSlingScriptEngine {
    private PythonInterpreter interp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonScriptEngine(PythonScriptEngineFactory factory) {
        super((ScriptEngineFactory)((Object)factory));
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.interp = new PythonInterpreter();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public Object eval(Reader script, ScriptContext scriptContext) throws ScriptException {
        Bindings bindings = scriptContext.getBindings(100);
        SlingScriptHelper helper = (SlingScriptHelper)bindings.get("sling");
        if (helper == null) {
            throw new ScriptException("SlingScriptHelper missing from bindings");
        }
        if (helper.getRequest() != null && !"GET".equals(helper.getRequest().getMethod())) {
            throw new ScriptException("Python scripting only supports GET requests");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            StringBuffer scriptString = new StringBuffer();
            BufferedReader bufferedScript = new BufferedReader(script);
            String nextLine = bufferedScript.readLine();
            String newLine = System.getProperty("line.separator");
            while (nextLine != null) {
                scriptString.append(nextLine);
                scriptString.append(newLine);
                nextLine = bufferedScript.readLine();
            }
            this.interp.setOut(scriptContext.getWriter());
            this.interp.setErr(scriptContext.getErrorWriter());
            Iterator i$ = bindings.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entryObj;
                Map.Entry entry = entryObj = i$.next();
                this.interp.set((String)entry.getKey(), entry.getValue());
            }
            this.interp.exec(scriptString.toString());
        }
        catch (Throwable t) {
            ScriptException ex = new ScriptException("Failure running Python script:" + t);
            ex.initCause(t);
            throw ex;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return null;
    }
}

