/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl.picker;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resourcemerger.api.ResourceMergerService;
import org.apache.sling.resourcemerger.impl.MergedResource;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker2;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(name="org.apache.sling.resourcemerger.impl.MergedResourceProviderFactory")
@Designate(ocd=Configuration.class)
public class SearchPathBasedResourcePicker
implements MergedResourcePicker2,
ResourceMergerService {
    public static final String DEFAULT_ROOT = "/mnt/overlay";
    private String mergeRootPath;

    @Override
    public List<Resource> pickResources(ResourceResolver resolver, String relativePath, Resource relatedResource) {
        List<Resource> relatedMappedResources = null;
        if (relatedResource instanceof MergedResource) {
            relatedMappedResources = ((MergedResource)relatedResource).getMappedResources();
            if (relatedResource.getPath().equals(this.mergeRootPath + '/' + relativePath)) {
                return relatedMappedResources;
            }
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String[] searchPaths = resolver.getSearchPath();
        for (int i = searchPaths.length - 1; i >= 0; --i) {
            Resource resource;
            String basePath = searchPaths[i];
            String fullPath = basePath + relativePath;
            int baseIndex = resources.size();
            Resource baseResource = null;
            if (relatedMappedResources != null && relatedMappedResources.size() > baseIndex) {
                baseResource = relatedMappedResources.get(baseIndex);
            }
            Resource resource2 = resource = baseResource != null ? this.getFromBaseResource(resolver, baseResource, fullPath) : null;
            if (resource == null && (resource = resolver.getResource(fullPath)) == null) {
                resource = new NonExistingResource(resolver, fullPath);
            }
            resources.add(resource);
        }
        return resources;
    }

    private Resource getFromBaseResource(ResourceResolver resolver, Resource baseResource, String path) {
        Resource resource;
        String baseResourcePath = baseResource.getPath();
        if (path.startsWith(baseResourcePath + '/')) {
            String relPath = path.substring(baseResourcePath.length() + 1);
            resource = baseResource.getChild(relPath);
        } else if (baseResourcePath.startsWith(path) && baseResourcePath.lastIndexOf(47) == path.length()) {
            resource = baseResource.getParent();
        } else {
            return null;
        }
        return resource != null ? resource : new NonExistingResource(resolver, path);
    }

    @Override
    public String getMergedResourcePath(String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("Provided relative path is null");
        }
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException("Provided path is not a relative path");
        }
        return this.mergeRootPath + "/" + relativePath;
    }

    @Override
    public Resource getMergedResource(Resource resource) {
        if (resource != null) {
            String[] searchPaths;
            ResourceResolver resolver = resource.getResourceResolver();
            for (String searchPathPrefix : searchPaths = resolver.getSearchPath()) {
                if (!resource.getPath().startsWith(searchPathPrefix)) continue;
                String searchPath = searchPathPrefix.substring(0, searchPathPrefix.length() - 1);
                return resolver.getResource(resource.getPath().replaceFirst(searchPath, this.mergeRootPath));
            }
        }
        return null;
    }

    @Override
    public boolean isMergedResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        return Boolean.TRUE.equals(resource.getResourceMetadata().get((Object)"sling.mergedResource"));
    }

    @Override
    public String getResourcePath(String searchPath, String mergedResourcePath) {
        if (searchPath == null || !searchPath.startsWith("/") || !searchPath.endsWith("/")) {
            throw new IllegalArgumentException("Provided path is not a valid search path: " + searchPath);
        }
        if (mergedResourcePath == null || !mergedResourcePath.startsWith(this.mergeRootPath + "/")) {
            throw new IllegalArgumentException("Provided path does not point to a merged resource: " + mergedResourcePath);
        }
        return searchPath + mergedResourcePath.substring(this.mergeRootPath.length() + 1);
    }

    @Activate
    protected void configure(Configuration configuration) {
        this.mergeRootPath = configuration.merge_root();
    }

    @ObjectClassDefinition(id="org.apache.sling.resourcemerger.impl.MergedResourceProviderFactory", name="Apache Sling Resource Merger - Search Path Based Resource Picker", description="This resource picker delivers merged resources based on the search paths (overlay approach).")
    static @interface Configuration {
        @AttributeDefinition(name="Root", description="The mount point of merged resources.")
        public String merge_root() default "/mnt/overlay";

        @AttributeDefinition(name="Read Only", description="Specifies if the resources are read-only or can be modified.")
        public boolean merge_readOnly() default true;
    }
}

