/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class MergedValueMap
extends ValueMapDecorator {
    private static final Set<String> EXCLUDED_PROPERTIES = new HashSet<String>();

    public MergedValueMap(List<ValueMap> valueMaps) {
        super(new HashMap());
        ArrayList<String> propertyNamesToHide = new ArrayList<String>(EXCLUDED_PROPERTIES);
        for (ValueMap vm : valueMaps) {
            String[] propertiesToHide = (String[])vm.get("sling:hideProperties", String[].class);
            if (propertiesToHide != null) {
                for (String propName : propertiesToHide) {
                    if (propName.equals("*")) {
                        this.clear();
                        break;
                    }
                    propertyNamesToHide.add(propName);
                }
            }
            this.putAll((Map)vm);
        }
        for (String propertyNameToHide : propertyNamesToHide) {
            this.remove(propertyNameToHide);
        }
    }

    static {
        EXCLUDED_PROPERTIES.add("sling:hideProperties");
        EXCLUDED_PROPERTIES.add("sling:hideResource");
        EXCLUDED_PROPERTIES.add("sling:hideChildren");
        EXCLUDED_PROPERTIES.add("sling:orderBefore");
    }
}

