/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.List;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;
import org.apache.sling.resourcemerger.impl.MergedValueMap;

public class MergedResource
extends AbstractResource {
    private final ResourceResolver resolver;
    private final String path;
    private final String resourceType;
    private final String resourceSuperType;
    private final ResourceMetadata metadata = new ResourceMetadata();
    private final ValueMap properties;

    MergedResource(ResourceResolver resolver, String mergeRootPath, String relativePath, List<Resource> mappedResources, List<ValueMap> valueMaps) {
        String slingPropRT;
        this.resolver = resolver;
        this.path = relativePath.length() == 0 ? mergeRootPath : mergeRootPath + "/" + relativePath;
        this.properties = new DeepReadValueMapDecorator((Resource)this, (ValueMap)new MergedValueMap(valueMaps));
        String rt = slingPropRT = (String)this.properties.get("sling:resourceType", String.class);
        if (rt == null) {
            rt = relativePath.length() == 0 ? "/" : relativePath;
        }
        for (Resource rsrc : mappedResources) {
            String value = rsrc.getResourceType();
            if (value == null) continue;
            rt = value;
        }
        this.resourceType = rt;
        this.resourceSuperType = !rt.equals(slingPropRT) ? slingPropRT : null;
        this.metadata.put("sling.mergedResource", (Object)true);
        String[] resourcePaths = new String[mappedResources.size()];
        int i = 0;
        for (Resource rsrc : mappedResources) {
            resourcePaths[i] = rsrc.getPath();
            ++i;
        }
        this.metadata.put("sling.mergedResources", (Object)resourcePaths);
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        return this.resourceSuperType;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.properties;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Resource r = (Resource)o;
        return r.getPath().equals(this.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return "MergedResource [path=" + this.path + ", resources=" + this.metadata.get((Object)"sling.mergedResources") + "]";
    }
}

