/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedValueMap
extends ValueMapDecorator {
    private static final Set<String> EXCLUDED_PROPERTIES = new HashSet<String>();

    public MergedValueMap(List<ValueMap> valueMaps) {
        super(new HashMap());
        block0: for (ValueMap vm : valueMaps) {
            if (this.isEmpty()) {
                this.putAll((Map)vm);
                continue;
            }
            for (String key : vm.keySet()) {
                if (this.isExcludedProperty(key)) continue;
                this.put(key, vm.get((Object)key));
            }
            String[] propertiesToHide = (String[])vm.get("sling:hideProperties", String[].class);
            if (propertiesToHide == null) continue;
            for (String propName : propertiesToHide) {
                if (propName.equals("*")) {
                    this.clear();
                    continue block0;
                }
                this.remove(propName);
            }
        }
        for (String excludedProperty : EXCLUDED_PROPERTIES) {
            this.remove(excludedProperty);
        }
    }

    private boolean isExcludedProperty(String key) {
        return EXCLUDED_PROPERTIES.contains(key);
    }

    static {
        EXCLUDED_PROPERTIES.add("sling:hideProperties");
        EXCLUDED_PROPERTIES.add("sling:hideResource");
        EXCLUDED_PROPERTIES.add("sling:hideChildren");
        EXCLUDED_PROPERTIES.add("sling:orderBefore");
    }
}

