/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.sling.commons.threads.ModifiableThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.commons.threads.impl.DefaultThreadPool;
import org.apache.sling.commons.threads.impl.ThreadPoolFacade;
import org.apache.sling.commons.threads.impl.ThreadPoolMBeanImpl;
import org.apache.sling.commons.threads.jmx.ThreadPoolMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThreadPoolManager
implements ThreadPoolManager,
ManagedServiceFactory {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    protected final Map<String, Entry> pools = new HashMap<String, Entry>();
    protected final Dictionary<String, Object> properties;
    protected final BundleContext bundleContext;

    public DefaultThreadPoolManager(BundleContext bc, Dictionary<String, Object> props) {
        this.properties = props;
        this.bundleContext = bc;
        this.logger.info("Started Apache Sling Thread Pool Manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.logger.debug("Disposing all thread pools");
        HashMap<String, Entry> localCopy = new HashMap<String, Entry>(this.pools.size());
        Map<String, Entry> map = this.pools;
        synchronized (map) {
            localCopy.putAll(this.pools);
            this.pools.clear();
        }
        for (Entry entry : localCopy.values()) {
            entry.unregisterMBean();
            entry.shutdown();
        }
        this.logger.info("Stopped Apache Sling Thread Pool Manager");
    }

    private ThreadPoolConfig createConfig(Dictionary<String, Object> props) {
        ModifiableThreadPoolConfig config = new ModifiableThreadPoolConfig();
        if (props.get("minPoolSize") != null) {
            config.setMinPoolSize((Integer)props.get("minPoolSize"));
        }
        if (props.get("maxPoolSize") != null) {
            config.setMaxPoolSize((Integer)props.get("maxPoolSize"));
        }
        if (props.get("queueSize") != null) {
            config.setQueueSize((Integer)props.get("queueSize"));
        }
        if (props.get("keepAliveTime") != null) {
            config.setKeepAliveTime((Long)props.get("keepAliveTime"));
        }
        if (props.get("blockPolicy") != null) {
            config.setBlockPolicy(ThreadPoolConfig.ThreadPoolPolicy.valueOf(props.get("blockPolicy").toString()));
        }
        if (props.get("shutdownGraceful") != null) {
            config.setShutdownGraceful((Boolean)props.get("shutdownGraceful"));
        }
        if (props.get("shutdownWaitTime") != null) {
            config.setShutdownWaitTimeMs((Integer)props.get("shutdownWaitTime"));
        }
        if (props.get("priority") != null) {
            config.setPriority(ThreadPoolConfig.ThreadPriority.valueOf(props.get("priority").toString()));
        }
        if (props.get("daemon") != null) {
            config.setDaemon((Boolean)props.get("daemon"));
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadPool get(String name) {
        String poolName = name == null ? "default" : name;
        Entry entry = null;
        boolean created = false;
        ThreadPoolFacade threadPool = null;
        Map<String, Entry> map = this.pools;
        synchronized (map) {
            entry = this.pools.get(poolName);
            if (entry == null) {
                this.logger.debug("Creating new pool with name {}", (Object)poolName);
                ModifiableThreadPoolConfig config = new ModifiableThreadPoolConfig();
                entry = new Entry(null, config, poolName, this.bundleContext);
                created = true;
                this.pools.put(poolName, entry);
            }
            threadPool = entry.incUsage();
        }
        if (created) {
            entry.registerMBean();
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ThreadPool pool) {
        if (pool instanceof ThreadPoolFacade) {
            Entry removedEntry = null;
            Map<String, Entry> map = this.pools;
            synchronized (map) {
                Entry entry = this.pools.get(pool.getName());
                if (entry != null) {
                    entry.decUsage();
                    if (!entry.isUsed()) {
                        removedEntry = entry;
                        this.pools.remove(pool.getName());
                    }
                }
            }
            if (removedEntry != null) {
                removedEntry.unregisterMBean();
            }
        }
    }

    @Override
    public ThreadPool create(ThreadPoolConfig config) {
        return this.create(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadPool create(ThreadPoolConfig config, String label) {
        StackTraceElement[] stackTrace;
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null.");
        }
        if (label == null && (stackTrace = new Exception().getStackTrace()) != null && stackTrace.length > 1) {
            label = stackTrace[1].getClassName().equals(this.getClass().getName()) ? stackTrace[2].getClassName() : stackTrace[1].getClassName();
        }
        String name = "ThreadPool-" + UUID.randomUUID().toString() + (label == null ? "" : " (" + label + ")");
        Entry entry = new Entry(null, config, name, this.bundleContext);
        ThreadPoolFacade threadPool = null;
        Map<String, Entry> map = this.pools;
        synchronized (map) {
            this.pools.put(name, entry);
            threadPool = entry.incUsage();
        }
        entry.registerMBean();
        return threadPool;
    }

    public String getName() {
        return this.properties.get("service.description").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getConfigurations() {
        Map<String, Entry> map = this.pools;
        synchronized (map) {
            return this.pools.values().toArray(new Entry[this.pools.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        String name = (String)properties.get("name");
        if (name == null || name.length() == 0) {
            throw new ConfigurationException("name", "Property is missing or empty.");
        }
        this.logger.debug("Updating {} with {}", (Object)pid, (Object)properties);
        Entry createdEntry = null;
        Map<String, Entry> map = this.pools;
        synchronized (map) {
            ThreadPoolConfig config = this.createConfig(properties);
            Entry foundEntry = null;
            for (Entry entry : this.pools.values()) {
                if (!pid.equals(entry.getPid())) continue;
                foundEntry = entry;
                break;
            }
            if (foundEntry == null) {
                for (Entry entry : this.pools.values()) {
                    if (!name.equals(entry.getName())) continue;
                    foundEntry = entry;
                    break;
                }
            }
            if (foundEntry != null) {
                if (!name.equals(foundEntry.getName())) {
                    this.pools.remove(foundEntry.getName());
                    this.pools.put(name, foundEntry);
                }
                foundEntry.update(config, name, pid);
            } else {
                createdEntry = new Entry(pid, config, name, this.bundleContext);
                this.pools.put(name, createdEntry);
            }
        }
        if (createdEntry != null) {
            createdEntry.registerMBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(String pid) {
        this.logger.debug("Deleting " + pid);
        Map<String, Entry> map = this.pools;
        synchronized (map) {
            Entry foundEntry = null;
            for (Entry entry : this.pools.values()) {
                if (!pid.equals(entry.getPid())) continue;
                foundEntry = entry;
                break;
            }
            if (foundEntry != null) {
                this.pools.remove(foundEntry.getName());
                if (foundEntry.isUsed()) {
                    String name = "ThreadPool-" + UUID.randomUUID().toString();
                    foundEntry.update(new ModifiableThreadPoolConfig(), name, null);
                    this.pools.put(name, foundEntry);
                }
            }
        }
    }

    protected static final class Entry {
        private static final Logger logger = LoggerFactory.getLogger(Entry.class);
        private volatile String pid;
        private volatile int count;
        private volatile ThreadPoolConfig config;
        private volatile String name;
        private volatile ThreadPoolFacade pool;
        private ServiceRegistration mbeanRegistration;
        private BundleContext bundleContext;
        private Object usagelock = new Object();

        public Entry(String pid, ThreadPoolConfig config, String name, BundleContext bundleContext) {
            this.pid = pid;
            this.config = config;
            this.name = name;
            this.bundleContext = bundleContext;
        }

        public String getPid() {
            return this.pid;
        }

        public void shutdown() {
            if (this.pool != null) {
                this.pool.shutdown();
                this.pool = null;
            }
        }

        public ThreadPoolFacade incUsage() {
            if (this.pool == null) {
                this.pool = new ThreadPoolFacade(new DefaultThreadPool(this.name, this.config));
            }
            ++this.count;
            return this.pool;
        }

        public void decUsage() {
            --this.count;
            if (this.count == 0) {
                this.shutdown();
            }
        }

        public void update(ThreadPoolConfig config, String name, String pid) {
            if (this.pool != null) {
                this.pool.setName(name);
                if (!this.config.equals(config)) {
                    this.pool.setPool(new DefaultThreadPool(name, config));
                }
            }
            this.config = config;
            this.name = name;
            this.pid = pid;
        }

        public String getName() {
            return this.name;
        }

        public boolean isUsed() {
            return this.count > 0;
        }

        public ThreadPoolConfig getConfig() {
            return this.config;
        }

        public ThreadPoolExecutor getExecutor() {
            if (this.pool != null) {
                return this.pool.getExecutor();
            }
            return null;
        }

        protected void unregisterMBean() {
            if (this.mbeanRegistration != null) {
                this.mbeanRegistration.unregister();
                this.mbeanRegistration = null;
            }
        }

        protected void registerMBean() {
            try {
                Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
                ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=threads,service=ThreadPool,name=" + this.name);
                ThreadPoolMBeanImpl mbean = new ThreadPoolMBeanImpl(this);
                this.mbeanRegistration = this.bundleContext.registerService(ThreadPoolMBean.class.getName(), (Object)mbean, mbeanProps);
            }
            catch (Throwable t) {
                logger.warn("Unable to register Thread Pool MBean", t);
            }
        }
    }
}

