/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.sling.commons.threads.ModifiableThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.impl.ExtendedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThreadPool
implements ThreadPool {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String name;
    protected ThreadPoolExecutor executor;
    protected final ModifiableThreadPoolConfig configuration;

    public DefaultThreadPool(String name, ThreadPoolConfig origConfig) {
        ThreadFactory delegateThreadFactory;
        this.name = name != null ? name : "default";
        this.logger.info("Initializing thread pool [{}]  ...", (Object)this.name);
        this.configuration = new ModifiableThreadPoolConfig(origConfig);
        if (this.configuration.getFactory() == null) {
            this.logger.debug("Thread pool [{}] ; No ThreadFactory is configured. Will use JVM default thread factory: {}", (Object)this.name, (Object)ExtendedThreadFactory.class.getName());
            delegateThreadFactory = Executors.defaultThreadFactory();
        } else {
            delegateThreadFactory = this.configuration.getFactory();
        }
        if (this.configuration.getMinPoolSize() < 1) {
            this.configuration.setMinPoolSize(1);
            this.logger.warn("min-pool-size < 1 for pool \"" + this.name + "\". Set to 1");
        }
        if (this.configuration.getMaxPoolSize() < 0) {
            this.configuration.setMaxPoolSize(Integer.MAX_VALUE);
        }
        ExtendedThreadFactory threadFactory = new ExtendedThreadFactory(delegateThreadFactory, this.configuration.getPriority(), this.configuration.isDaemon());
        if (this.configuration.getKeepAliveTime() < 0L) {
            this.configuration.setKeepAliveTime(1000L);
            this.logger.warn("keep-alive-time-ms < 0 for pool \"" + this.name + "\". Set to 1000");
        }
        AbstractQueue queue = this.configuration.getQueueSize() != 0 ? (this.configuration.getQueueSize() > 0 ? new ArrayBlockingQueue(this.configuration.getQueueSize()) : new LinkedBlockingQueue()) : new SynchronousQueue();
        RejectedExecutionHandler handler = null;
        switch (this.configuration.getBlockPolicy()) {
            case ABORT: {
                handler = new ThreadPoolExecutor.AbortPolicy();
                break;
            }
            case DISCARD: {
                handler = new ThreadPoolExecutor.DiscardPolicy();
                break;
            }
            case DISCARDOLDEST: {
                handler = new ThreadPoolExecutor.DiscardOldestPolicy();
                break;
            }
            case RUN: {
                handler = new ThreadPoolExecutor.CallerRunsPolicy();
            }
        }
        this.executor = new ThreadPoolExecutor(this.configuration.getMinPoolSize(), this.configuration.getMaxPoolSize(), this.configuration.getKeepAliveTime(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), threadFactory, handler);
        this.logger.info("Thread pool [{}] initialized.", (Object)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ThreadPoolConfig getConfiguration() {
        return this.configuration;
    }

    @Override
    public void execute(Runnable runnable) {
        this.checkExecutor();
        if (runnable != null) {
            if (this.logger.isDebugEnabled()) {
                this.logOperation("Executing runnable: ", runnable);
            }
            this.executor.execute(runnable);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        this.checkExecutor();
        if (this.logger.isDebugEnabled()) {
            this.logOperation("Submitting callable: ", callable);
        }
        return this.executor.submit(callable);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        this.checkExecutor();
        if (this.logger.isDebugEnabled()) {
            this.logOperation("Submitting runnable: ", runnable);
        }
        return this.executor.submit(runnable);
    }

    public void shutdown() {
        this.logger.info("Shutting down thread pool [{}] ...", (Object)this.name);
        if (this.executor != null) {
            if (this.configuration.isShutdownGraceful()) {
                this.executor.shutdown();
            } else {
                this.executor.shutdownNow();
            }
            try {
                if (this.configuration.getShutdownWaitTimeMs() > 0 && !this.executor.awaitTermination(this.configuration.getShutdownWaitTimeMs(), TimeUnit.MILLISECONDS)) {
                    this.logger.warn("Running commands have not terminated within " + this.configuration.getShutdownWaitTimeMs() + "ms. Will shut them down by interruption");
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                this.logger.error("Cannot shutdown thread pool [" + this.name + "]", (Throwable)ie);
            }
            this.executor = null;
        }
        this.logger.info("Thread pool [{}] is shut down.", (Object)this.name);
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    private void checkExecutor() {
        if (this.executor == null) {
            throw new IllegalStateException("Thread pool " + this.name + " is already shutdown.");
        }
    }

    private void logOperation(String msg, Object obj) {
        this.logger.debug("{} {}, pool={}, active={}, corePoolSize={}, maxPoolSize={}, queueSize={}", new Object[]{msg, obj, this.name, this.executor.getActiveCount(), this.executor.getCorePoolSize(), this.executor.getMaximumPoolSize(), this.executor.getQueue().size()});
    }
}

