/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.classloader.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.commons.classloader.impl.BundleProxyClassLoader;
import org.apache.sling.commons.classloader.impl.DynamicClassLoaderManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class DynamicClassLoaderManagerFactory
implements ServiceFactory {
    private final PackageAdmin pckAdmin;
    private final BundleContext context;
    private final Set<Long> usedBundles = Collections.synchronizedSet(new HashSet());
    private final Set<String> unresolvedPackages = Collections.synchronizedSet(new HashSet());

    public DynamicClassLoaderManagerFactory(BundleContext ctx, PackageAdmin pckAdmin) {
        this.context = ctx;
        this.pckAdmin = pckAdmin;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        DynamicClassLoaderManagerImpl manager = new DynamicClassLoaderManagerImpl(this.context, this.pckAdmin, new BundleProxyClassLoader(bundle), this);
        return manager;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        if (service != null) {
            ((DynamicClassLoaderManagerImpl)service).deactivate();
        }
    }

    public boolean isBundleUsed(long bundleId) {
        return this.usedBundles.contains(bundleId);
    }

    public void addUsedBundle(Bundle bundle) {
        long id = bundle.getBundleId();
        this.usedBundles.add(id);
    }

    public void addUnresolvedPackage(String pckName) {
        this.unresolvedPackages.add(pckName);
    }

    public boolean hasUnresolvedPackages(Bundle bundle) {
        ExportedPackage[] pcks;
        if (!this.unresolvedPackages.isEmpty() && (pcks = this.pckAdmin.getExportedPackages(bundle)) != null) {
            for (ExportedPackage pck : pcks) {
                if (!this.unresolvedPackages.contains(pck.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

