/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.boot.configurationprocessor.MetadataGenerationEnvironment;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

abstract class PropertyDescriptor {
    private final String name;
    private final TypeMirror type;
    private final TypeElement declaringElement;
    private final ExecutableElement getter;

    PropertyDescriptor(String name, TypeMirror type, TypeElement declaringElement, ExecutableElement getter) {
        this.declaringElement = declaringElement;
        this.name = name;
        this.type = type;
        this.getter = getter;
    }

    String getName() {
        return this.name;
    }

    TypeMirror getType() {
        return this.type;
    }

    protected final TypeElement getDeclaringElement() {
        return this.declaringElement;
    }

    protected final ExecutableElement getGetter() {
        return this.getter;
    }

    final ItemMetadata resolveItemMetadata(String prefix, MetadataGenerationEnvironment environment2) {
        if (this.isNested(environment2)) {
            return this.resolveItemMetadataGroup(prefix, environment2);
        }
        if (this.isProperty(environment2)) {
            return this.resolveItemMetadataProperty(prefix, environment2);
        }
        return null;
    }

    boolean isNested(MetadataGenerationEnvironment environment2) {
        Element typeElement = environment2.getTypeUtils().asElement(this.getType());
        if (!(typeElement instanceof TypeElement) || typeElement.getKind() == ElementKind.ENUM || environment2.getConfigurationPropertiesAnnotation(this.getGetter()) != null) {
            return false;
        }
        if (this.isMarkedAsNested(environment2)) {
            return true;
        }
        return !this.isCyclePresent(typeElement, this.getDeclaringElement()) && this.isParentTheSame(environment2, typeElement, this.getDeclaringElement());
    }

    protected abstract boolean isMarkedAsNested(MetadataGenerationEnvironment var1);

    private boolean isCyclePresent(Element returnType, Element element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return false;
        }
        if (element.getEnclosingElement().equals(returnType)) {
            return true;
        }
        return this.isCyclePresent(returnType, element.getEnclosingElement());
    }

    private boolean isParentTheSame(MetadataGenerationEnvironment environment2, Element returnType, TypeElement element) {
        if (returnType == null || element == null) {
            return false;
        }
        returnType = this.getTopLevelType(returnType);
        Element candidate = element;
        while (candidate != null && candidate instanceof TypeElement) {
            if (returnType.equals(this.getTopLevelType(candidate))) {
                return true;
            }
            candidate = environment2.getTypeUtils().asElement(candidate.getSuperclass());
        }
        return false;
    }

    private Element getTopLevelType(Element element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return element;
        }
        return this.getTopLevelType(element.getEnclosingElement());
    }

    private ItemMetadata resolveItemMetadataGroup(String prefix, MetadataGenerationEnvironment environment2) {
        Element propertyElement = environment2.getTypeUtils().asElement(this.getType());
        String nestedPrefix = ConfigurationMetadata.nestedPrefix(prefix, this.getName());
        String dataType = environment2.getTypeUtils().getQualifiedName(propertyElement);
        String ownerType = environment2.getTypeUtils().getQualifiedName(this.getDeclaringElement());
        String sourceMethod = this.getGetter() != null ? this.getGetter().toString() : null;
        return ItemMetadata.newGroup(nestedPrefix, dataType, ownerType, sourceMethod);
    }

    private ItemMetadata resolveItemMetadataProperty(String prefix, MetadataGenerationEnvironment environment2) {
        String dataType = this.resolveType(environment2);
        String ownerType = environment2.getTypeUtils().getQualifiedName(this.getDeclaringElement());
        String description = this.resolveDescription(environment2);
        Object defaultValue = this.resolveDefaultValue(environment2);
        ItemDeprecation deprecation = this.resolveItemDeprecation(environment2);
        return ItemMetadata.newProperty(prefix, this.getName(), dataType, ownerType, null, description, defaultValue, deprecation);
    }

    private String resolveType(MetadataGenerationEnvironment environment2) {
        return environment2.getTypeUtils().getType(this.getDeclaringElement(), this.getType());
    }

    private ItemDeprecation resolveItemDeprecation(MetadataGenerationEnvironment environment2) {
        boolean deprecated = this.getDeprecatableElements().stream().anyMatch(environment2::isDeprecated);
        return deprecated ? environment2.resolveItemDeprecation(this.getGetter()) : null;
    }

    protected abstract String resolveDescription(MetadataGenerationEnvironment var1);

    protected abstract Object resolveDefaultValue(MetadataGenerationEnvironment var1);

    protected abstract List<Element> getDeprecatableElements();

    abstract boolean isProperty(MetadataGenerationEnvironment var1);
}

