/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.selector;

import java.util.Objects;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;

public final class SofaUpstream
extends CommonUpstream {
    private String register;
    private String appName;
    private int port;
    private int weight;
    private int warmup;

    private SofaUpstream(Builder builder) {
        boolean statusValue = builder.statusValue;
        if (!builder.statusSet) {
            statusValue = SofaUpstream.defaultStatus();
        }
        this.setUpstreamHost(builder.upstreamHost);
        this.setProtocol(builder.protocol);
        this.setUpstreamUrl(builder.upstreamUrl);
        this.weight = builder.weight;
        this.setStatus(statusValue);
        this.setTimestamp(builder.timestamp);
        this.warmup = builder.warmup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRegister() {
        return this.register;
    }

    public void setRegister(String registry) {
        this.register = this.register;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public void setWarmup(int warmup) {
        this.warmup = warmup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SofaUpstream)) {
            return false;
        }
        SofaUpstream that = (SofaUpstream)o;
        return this.port == that.port && Objects.equals(this.register, that.register) && Objects.equals(this.appName, that.appName) && Objects.equals(this.getProtocol(), that.getProtocol()) && Objects.equals(this.getUpstreamUrl(), that.getUpstreamUrl()) && Objects.equals(this.isGray(), that.isGray());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.register, this.appName, this.port, this.isGray());
    }

    @Override
    public String toString() {
        return "SofaUpstream{registry='" + this.register + "', appName='" + this.appName + "', protocol='" + this.getProtocol() + "', port=" + this.port + ", upstreamUrl='" + this.getUpstreamUrl() + "', gray=" + this.isGray() + ", weight=" + this.weight + ", warmup=" + this.warmup + ", status=" + this.isStatus() + ", timestamp=" + this.getTimestamp() + "'}";
    }

    public static final class Builder {
        private String upstreamHost;
        private String protocol;
        private String upstreamUrl;
        private int weight;
        private boolean statusSet;
        private boolean statusValue;
        private long timestamp;
        private int warmup;

        private Builder() {
        }

        public SofaUpstream build() {
            return new SofaUpstream(this);
        }

        public Builder upstreamHost(String upstreamHost) {
            this.upstreamHost = upstreamHost;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder upstreamUrl(String upstreamUrl) {
            this.upstreamUrl = upstreamUrl;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder status(boolean status) {
            this.statusValue = status;
            this.statusSet = true;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder warmup(int warmup) {
            this.warmup = warmup;
            return this;
        }
    }
}

