/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloThreadFactory
implements ThreadFactory {
    private static Logger log = LoggerFactory.getLogger(ApolloThreadFactory.class);
    private final AtomicLong threadNumber = new AtomicLong(1L);
    private final String namePrefix;
    private final boolean daemon;
    private static final ThreadGroup threadGroup = new ThreadGroup("Apollo");

    public static ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public static ThreadFactory create(String namePrefix, boolean daemon) {
        return new ApolloThreadFactory(namePrefix, daemon);
    }

    public static boolean waitAllShutdown(int timeoutInMillis) {
        ThreadGroup group = ApolloThreadFactory.getThreadGroup();
        Thread[] activeThreads = new Thread[group.activeCount()];
        group.enumerate(activeThreads);
        HashSet<Thread> alives = new HashSet<Thread>(Arrays.asList(activeThreads));
        HashSet dies = new HashSet();
        log.info("Current ACTIVE thread count is: {}", (Object)alives.size());
        long expire = System.currentTimeMillis() + (long)timeoutInMillis;
        while (System.currentTimeMillis() < expire) {
            ApolloThreadFactory.classify(alives, dies, new ClassifyStandard<Thread>(){

                @Override
                public boolean satisfy(Thread thread) {
                    return !thread.isAlive() || thread.isInterrupted() || thread.isDaemon();
                }
            });
            if (alives.size() > 0) {
                log.info("Alive apollo threads: {}", (Object)alives);
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            log.info("All apollo threads are shutdown.");
            return true;
        }
        log.warn("Some apollo threads are still alive but expire time has reached, alive threads: {}", (Object)alives);
        return false;
    }

    private static <T> void classify(Set<T> src, Set<T> des, ClassifyStandard<T> standard) {
        HashSet<T> set = new HashSet<T>();
        for (T t2 : src) {
            if (!standard.satisfy(t2)) continue;
            set.add(t2);
        }
        src.removeAll(set);
        des.addAll(set);
    }

    private ApolloThreadFactory(String namePrefix, boolean daemon) {
        this.namePrefix = namePrefix;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(threadGroup, runnable, threadGroup.getName() + "-" + this.namePrefix + "-" + this.threadNumber.getAndIncrement());
        thread.setDaemon(this.daemon);
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }

    private static interface ClassifyStandard<T> {
        public boolean satisfy(T var1);
    }
}

