/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.micrometer.observation.Observation;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.resolver.AddressResolverGroup;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.netty.ChannelBindException;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.Metrics;
import reactor.netty.ReactorNetty;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.TransportConfig;
import reactor.netty.transport.TransportConnector;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class NewConnectionProvider
implements ConnectionProvider {
    static final Logger log = Loggers.getLogger(NewConnectionProvider.class);
    static final NewConnectionProvider INSTANCE = new NewConnectionProvider();

    NewConnectionProvider() {
    }

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver observer, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return Mono.create((MonoSink<T> sink) -> {
            SocketAddress remote = null;
            if (remoteAddress != null) {
                remote = Objects.requireNonNull((SocketAddress)remoteAddress.get(), "Remote Address supplier returned null");
            }
            if (remote != null && resolverGroup != null) {
                Observation currentObservation;
                Context currentContext = Context.of(sink.contextView());
                if (config.metricsRecorder() != null && reactor.netty.internal.util.Metrics.isMicrometerAvailable() && (currentObservation = Metrics.currentObservation(currentContext)) != null) {
                    currentContext = Metrics.updateContext(currentContext, currentObservation);
                }
                NewConnectionObserver connectionObserver = new NewConnectionObserver((MonoSink<Connection>)sink, currentContext, observer);
                ChannelInitializer<Channel> channelInitializer = config.channelInitializer(connectionObserver, remote, false);
                DisposableConnect disposableConnect = new DisposableConnect((MonoSink<Connection>)sink, currentContext, config.bindAddress());
                TransportConnector.connect(config, remote, resolverGroup, channelInitializer, currentContext).subscribe(disposableConnect);
            } else {
                InetSocketAddress localInet;
                Objects.requireNonNull(config.bindAddress(), "bindAddress");
                SocketAddress local = Objects.requireNonNull(config.bindAddress().get(), "Bind Address supplier returned null");
                if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
                    local = AddressUtils.createResolved(localInet.getHostName(), localInet.getPort());
                }
                NewConnectionObserver connectionObserver = new NewConnectionObserver((MonoSink<Connection>)sink, observer);
                ChannelInitializer<Channel> channelInitializer = config.channelInitializer(connectionObserver, null, true);
                DisposableConnect disposableConnect = new DisposableConnect((MonoSink<Connection>)sink, config.bindAddress());
                TransportConnector.bind(config, channelInitializer, local, local instanceof DomainSocketAddress).subscribe(disposableConnect);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public int maxConnections() {
        return 1;
    }

    static final class NewConnectionObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final ConnectionObserver obs;

        NewConnectionObserver(MonoSink<Connection> sink, ConnectionObserver obs) {
            this(sink, Context.of(sink.contextView()), obs);
        }

        NewConnectionObserver(MonoSink<Connection> sink, Context currentContext, ConnectionObserver obs) {
            this.sink = sink;
            this.currentContext = currentContext;
            this.obs = obs;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), newState, connection);
            }
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success(connection);
            } else if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive()) {
                connection.channel().close();
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onUncaughtException(Connection c, Throwable error) {
            this.sink.error(error);
            this.obs.onUncaughtException(c, error);
        }
    }

    static final class DisposableConnect
    implements CoreSubscriber<Channel>,
    Disposable {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final Supplier<? extends SocketAddress> bindAddress;
        Subscription subscription;

        DisposableConnect(MonoSink<Connection> sink, @Nullable Supplier<? extends SocketAddress> bindAddress) {
            this(sink, Context.of(sink.contextView()), bindAddress);
        }

        DisposableConnect(MonoSink<Connection> sink, Context currentContext, @Nullable Supplier<? extends SocketAddress> bindAddress) {
            this.sink = sink;
            this.currentContext = currentContext;
            this.bindAddress = bindAddress;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void dispose() {
            this.subscription.cancel();
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable t2) {
            if (this.bindAddress != null && (t2 instanceof BindException || t2 instanceof IOException && t2.getMessage() != null && t2.getMessage().contains("bind(..)"))) {
                this.sink.error(ChannelBindException.fail(this.bindAddress.get(), null));
            } else {
                this.sink.error(t2);
            }
        }

        @Override
        public void onNext(Channel channel) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Connected new channel"));
            }
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.subscription, s2)) {
                this.subscription = s2;
                this.sink.onCancel(this);
                s2.request(Long.MAX_VALUE);
            }
        }
    }
}

