/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.util;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.type.MethodMetadata;

public class BeanRegistrationUtil {
    private static final Map<String, String> RESERVED_BEAN_DEFINITIONS = new ConcurrentHashMap<String, String>();

    public static boolean registerBeanDefinitionIfNotExists(BeanDefinitionRegistry registry, Class<?> beanClass) {
        return BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, beanClass, null);
    }

    public static boolean registerBeanDefinitionIfNotExists(BeanDefinitionRegistry registry, Class<?> beanClass, Map<String, Object> extraPropertyValues) {
        return BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, beanClass.getName(), beanClass, extraPropertyValues);
    }

    public static boolean registerBeanDefinitionIfNotExists(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass) {
        return BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, beanName, beanClass, null);
    }

    public static boolean registerBeanDefinitionIfNotExists(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Map<String, Object> extraPropertyValues) {
        if (registry.containsBeanDefinition(beanName)) {
            return false;
        }
        String[] candidates = registry.getBeanDefinitionNames();
        String reservedBeanDefinition = RESERVED_BEAN_DEFINITIONS.get(beanClass.getName());
        for (String candidate : candidates) {
            MethodMetadata metadata;
            BeanDefinition beanDefinition = registry.getBeanDefinition(candidate);
            if (Objects.equals(beanDefinition.getBeanClassName(), beanClass.getName())) {
                return false;
            }
            if (reservedBeanDefinition == null || beanDefinition.getSource() == null || !(beanDefinition.getSource() instanceof MethodMetadata) || !Objects.equals(reservedBeanDefinition, String.format("%s#%s", (metadata = (MethodMetadata)beanDefinition.getSource()).getDeclaringClassName(), metadata.getMethodName()))) continue;
            return false;
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(beanClass).getBeanDefinition();
        if (extraPropertyValues != null) {
            for (Map.Entry<String, Object> entry : extraPropertyValues.entrySet()) {
                beanDefinition.getPropertyValues().add(entry.getKey(), entry.getValue());
            }
        }
        registry.registerBeanDefinition(beanName, beanDefinition);
        return true;
    }

    static {
        RESERVED_BEAN_DEFINITIONS.put("org.springframework.context.support.PropertySourcesPlaceholderConfigurer", "org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration#propertySourcesPlaceholderConfigurer");
    }
}

