/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.utils;

import com.google.common.base.Strings;
import java.net.URL;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaderUtil.class);
    private static ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private static String classPath = "";

    public static ClassLoader getLoader() {
        return loader;
    }

    public static String getClassPath() {
        return classPath;
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (LinkageError ex) {
            logger.error("Failed to load class: {}", (Object)className, (Object)ex);
            return false;
        }
    }

    static {
        if (loader == null) {
            logger.warn("Using system class loader");
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            URL url = loader.getResource("");
            if (url != null) {
                classPath = url.getPath();
                classPath = URLDecoder.decode(classPath, "utf-8");
            }
            if (Strings.isNullOrEmpty(classPath) || classPath.contains(".jar!")) {
                classPath = System.getProperty("user.dir");
            }
        }
        catch (Throwable ex) {
            classPath = System.getProperty("user.dir");
            logger.warn("Failed to locate class path, fallback to user.dir: {}", (Object)classPath, (Object)ex);
        }
    }
}

