/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.springcloud;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.PollingServerListUpdater;
import com.netflix.loadbalancer.ServerListUpdater;
import java.util.Optional;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.context.ShenyuContextDecorator;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.springcloud.SpringCloudPlugin;
import org.apache.shenyu.plugin.springcloud.context.SpringCloudShenyuContextDecorator;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.apache.shenyu.plugin.springcloud.loadbalance.LoadBalanceRule;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonClientSpecification;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnProperty(value={"shenyu.plugins.spring-cloud.enabled"}, havingValue="true", matchIfMissing=true)
public class SpringCloudPluginConfiguration {
    @Bean
    public ShenyuPlugin springCloudPlugin(ObjectProvider<LoadBalancerClient> loadBalancerClient) {
        return new SpringCloudPlugin((LoadBalancerClient)loadBalancerClient.getIfAvailable());
    }

    @Bean
    public ShenyuContextDecorator springCloudShenyuContextDecorator() {
        return new SpringCloudShenyuContextDecorator();
    }

    @Bean
    public PluginDataHandler springCloudPluginDataHandler() {
        return new SpringCloudPluginDataHandler();
    }

    @Bean
    public RibbonClientSpecification ribbonClientSpecification() {
        Class[] classes = new Class[]{SpringCloudClientConfiguration.class};
        return new RibbonClientSpecification(String.join((CharSequence)".", "DEFAULT".toLowerCase(), RibbonClientSpecification.class.getName()), classes);
    }

    static class SpringCloudClientConfiguration {
        SpringCloudClientConfiguration() {
        }

        @Bean
        public IRule ribbonRule() {
            return new LoadBalanceRule();
        }

        @Lazy
        @Bean
        public ServerListUpdater ribbonServerListUpdater(IClientConfig config, ShenyuConfig shenyuConfig) {
            Integer refreshInterval = Optional.ofNullable(shenyuConfig.getRibbon().getServerListRefreshInterval()).orElseGet(() -> 10000);
            config.set(CommonClientConfigKey.ServerListRefreshInterval, (Object)refreshInterval);
            return new PollingServerListUpdater(config);
        }
    }
}

