/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.wasm.api.loader;

import io.github.kawamuray.wasmtime.Engine;
import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Linker;
import io.github.kawamuray.wasmtime.Memory;
import io.github.kawamuray.wasmtime.Module;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.wasi.WasiCtx;
import io.github.kawamuray.wasmtime.wasi.WasiCtxBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.shenyu.plugin.wasm.api.exception.ShenyuWasmInitException;

public class WasmLoader
implements AutoCloseable {
    private static final String IMPORT_WASM_MODULE_NAME = "shenyu";
    private static final String MEMORY_METHOD_NAME = "memory";
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final String wasmName;
    private final WasiCtx wasiCtx = new WasiCtxBuilder().inheritStdout().inheritStderr().build();
    private final Store<Void> store = Store.withoutData((WasiCtx)this.wasiCtx);
    private final Linker linker = new Linker(this.store.engine());
    private final Map<String, Func> wasmCallJavaFuncMap = new HashMap<String, Func>();
    private final Module module;
    private final Memory memRef;

    public WasmLoader() {
        this(null, null);
    }

    public WasmLoader(Class<?> wasmClass, Function<Store<Void>, Map<String, Func>> initializer) {
        Class<?> clazz = Objects.nonNull(wasmClass) ? wasmClass : this.getClass();
        this.wasmName = clazz.getName() + ".wasm";
        try {
            Map<String, Func> wasmFunctionMap;
            URL resource = clazz.getClassLoader().getResource(this.wasmName);
            if (Objects.isNull(resource)) {
                throw new ShenyuWasmInitException("Can't find wasm file: " + this.wasmName);
            }
            byte[] wasmBytes = Files.readAllBytes(Paths.get(resource.toURI()));
            if (Objects.nonNull(initializer) && Objects.nonNull(wasmFunctionMap = initializer.apply(this.store)) && !wasmFunctionMap.isEmpty()) {
                this.wasmCallJavaFuncMap.putAll(wasmFunctionMap);
            }
            if (Objects.nonNull(wasmFunctionMap = this.initWasmCallJavaFunc(this.store)) && !wasmFunctionMap.isEmpty()) {
                this.wasmCallJavaFuncMap.putAll(wasmFunctionMap);
            }
            this.module = Module.fromBinary((Engine)this.store.engine(), (byte[])wasmBytes);
            WasiCtx.addToLinker((Linker)this.linker);
            if (!this.wasmCallJavaFuncMap.isEmpty()) {
                this.wasmCallJavaFuncMap.forEach((funcName, wasmCallJavaFunc) -> this.linker.define(this.store, IMPORT_WASM_MODULE_NAME, funcName, Extern.fromFunc((Func)wasmCallJavaFunc)));
            }
            this.linker.module(this.store, "", this.module);
            Optional<Extern> extern = this.getWasmExtern(MEMORY_METHOD_NAME);
            if (!extern.isPresent()) {
                throw new ShenyuWasmInitException("memory function not find in wasm file: " + this.wasmName);
            }
            this.memRef = extern.get().memory();
            Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        }
        catch (IOException | URISyntaxException e) {
            throw new ShenyuWasmInitException(e);
        }
    }

    protected Map<String, Func> initWasmCallJavaFunc(Store<Void> store) {
        return null;
    }

    public Optional<Extern> getWasmExtern(String wasiFuncName) {
        return this.linker.get(this.store, "", wasiFuncName);
    }

    public String getWasmName() {
        return this.wasmName;
    }

    public Store<Void> getStore() {
        return this.store;
    }

    public ByteBuffer getBuffer() {
        return this.memRef.buffer(this.store);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.wasiCtx.close();
            this.store.close();
            this.linker.close();
            if (!this.wasmCallJavaFuncMap.isEmpty()) {
                this.wasmCallJavaFuncMap.forEach((funcName, wasmCallJavaFunc) -> wasmCallJavaFunc.close());
            }
            this.module.close();
        }
    }
}

