/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.param.mapping.strategy;

import java.util.List;
import java.util.Map;
import org.apache.shenyu.common.dto.convert.rule.impl.ParamMappingRuleHandle;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.apache.shenyu.plugin.param.mapping.strategy.Operator;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JsonOperator
implements Operator {
    private static final Logger LOG = LoggerFactory.getLogger(JsonOperator.class);
    private final List<HttpMessageReader<?>> messageReaders;

    public JsonOperator(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    @Override
    public Mono<Void> apply(ServerWebExchange exchange, ShenyuPluginChain shenyuPluginChain, ParamMappingRuleHandle paramMappingRuleHandle) {
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
        Mono mono = serverRequest.bodyToMono(String.class).switchIfEmpty(Mono.just((Object)"")).flatMap(originalBody -> {
            LOG.info("get body data success data:{}", originalBody);
            String modify = this.operation((String)originalBody, paramMappingRuleHandle);
            return Mono.just((Object)modify);
        });
        BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)mono, String.class);
        HttpHeaders headers = new HttpHeaders();
        headers.putAll((Map)exchange.getRequest().getHeaders());
        headers.remove((Object)"Content-Length");
        CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, headers);
        return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
            ModifyServerHttpRequestDecorator decorator = new ModifyServerHttpRequestDecorator(headers, exchange.getRequest(), outputMessage);
            return Mono.just((Object)exchange.mutate().request((ServerHttpRequest)decorator).build());
        })).flatMap(arg_0 -> ((ShenyuPluginChain)shenyuPluginChain).execute(arg_0)).onErrorResume(throwable -> this.release(outputMessage, (Throwable)throwable));
    }

    static class ModifyServerHttpRequestDecorator
    extends ServerHttpRequestDecorator {
        private final HttpHeaders headers;
        private final CachedBodyOutputMessage cachedBodyOutputMessage;

        ModifyServerHttpRequestDecorator(HttpHeaders headers, ServerHttpRequest delegate, CachedBodyOutputMessage cachedBodyOutputMessage) {
            super(delegate);
            this.headers = headers;
            this.cachedBodyOutputMessage = cachedBodyOutputMessage;
        }

        public HttpHeaders getHeaders() {
            long contentLength = this.headers.getContentLength();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.putAll((Map)this.headers);
            if (contentLength > 0L) {
                httpHeaders.setContentLength(contentLength);
            } else {
                httpHeaders.set("Transfer-Encoding", "chunked");
            }
            return httpHeaders;
        }

        public Flux<DataBuffer> getBody() {
            return this.cachedBodyOutputMessage.getBody();
        }
    }
}

