/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.trie;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.TrieCacheTypeEnum;
import org.apache.shenyu.common.enums.TrieEventEnum;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.event.TrieEvent;
import org.apache.shenyu.plugin.base.trie.ShenyuTrie;
import org.springframework.context.ApplicationListener;

public class ShenyuTrieListener
implements ApplicationListener<TrieEvent> {
    private static final Object LOCK = new Object();

    public void onApplicationEvent(TrieEvent event) {
        ShenyuTrie shenyuTrie;
        List conditionDataList;
        TrieEventEnum eventEnum = event.getTrieEventEnum();
        TrieCacheTypeEnum cacheTypeEnum = event.getTrieCacheTypeEnum();
        Object source = event.getSource();
        if (TrieCacheTypeEnum.RULE.equals((Object)cacheTypeEnum)) {
            RuleData ruleData = (RuleData)source;
            conditionDataList = ruleData.getConditionDataList();
            shenyuTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.RULE.getTrieType());
        } else if (TrieCacheTypeEnum.SELECTOR.equals((Object)cacheTypeEnum)) {
            shenyuTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.SELECTOR.getTrieType());
            SelectorData selectorData = (SelectorData)source;
            conditionDataList = selectorData.getConditionList();
        } else {
            throw new IllegalStateException("Unexpected value: " + event.getTrieEventEnum());
        }
        List filterConditions = Optional.ofNullable(conditionDataList).orElse(Collections.emptyList()).stream().filter(conditionData -> ParamTypeEnum.URI.getName().equals(conditionData.getParamType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filterConditions)) {
            List<String> uriPaths = filterConditions.stream().map(ConditionData::getParamValue).collect(Collectors.toList());
            switch (eventEnum) {
                case INSERT: {
                    this.insertTrieNode(uriPaths, source, cacheTypeEnum, shenyuTrie);
                    break;
                }
                case UPDATE: {
                    this.updateTrieNode(uriPaths, source, cacheTypeEnum, shenyuTrie);
                    break;
                }
                case REMOVE: {
                    this.removeTrieNode(uriPaths, source, cacheTypeEnum, shenyuTrie);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + event.getTrieEventEnum());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void insertTrieNode(List<String> uriPaths, T data, TrieCacheTypeEnum cacheTypeEnum, ShenyuTrie trie) {
        Object object = LOCK;
        synchronized (object) {
            trie.remove(uriPaths, data, cacheTypeEnum);
            trie.putNode(uriPaths, data, cacheTypeEnum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void updateTrieNode(List<String> uriPaths, T data, TrieCacheTypeEnum cacheTypeEnum, ShenyuTrie trie) {
        List beforeConditionDataList;
        if (TrieCacheTypeEnum.RULE.equals((Object)cacheTypeEnum)) {
            RuleData ruleData = (RuleData)data;
            beforeConditionDataList = ruleData.getBeforeConditionDataList();
        } else {
            SelectorData selectorData = (SelectorData)data;
            beforeConditionDataList = selectorData.getBeforeConditionList();
        }
        List<String> beforeUriPaths = beforeConditionDataList.stream().filter(conditionData -> ParamTypeEnum.URI.getName().equals(conditionData.getParamType())).map(ConditionData::getParamValue).collect(Collectors.toList());
        Object object = LOCK;
        synchronized (object) {
            trie.remove(beforeUriPaths, data, cacheTypeEnum);
            trie.putNode(uriPaths, data, cacheTypeEnum);
        }
    }

    private <T> void removeTrieNode(List<String> uriPaths, T data, TrieCacheTypeEnum cacheTypeEnum, ShenyuTrie trie) {
        trie.remove(uriPaths, data, cacheTypeEnum);
    }
}

