/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sqlserver.visitor.impl;

import java.util.Collection;
import java.util.Collections;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.DCLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.AlterLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.AlterRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DenyUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.GrantStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.RevokeStatement;
import org.apache.shardingsphere.sql.parser.sqlserver.visitor.SQLServerVisitor;

public final class SQLServerDCLVisitor
extends SQLServerVisitor
implements DCLVisitor {
    @Override
    public ASTNode visitGrant(SQLServerStatementParser.GrantContext ctx) {
        GrantStatement result = new GrantStatement();
        if (null != ctx.classPrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classPrivilegesClause())) {
                result.getTables().add(each);
            }
        }
        if (null != ctx.classTypePrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classTypePrivilegesClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(SQLServerStatementParser.RevokeContext ctx) {
        RevokeStatement result = new RevokeStatement();
        if (null != ctx.classPrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classPrivilegesClause())) {
                result.getTables().add(each);
            }
        }
        if (null != ctx.classTypePrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classTypePrivilegesClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    private Collection<SimpleTableSegment> getTableFromPrivilegeClause(SQLServerStatementParser.ClassPrivilegesClauseContext ctx) {
        return null == ctx.onClassClause().tableName() ? Collections.emptyList() : Collections.singletonList((SimpleTableSegment)this.visit((ParseTree)ctx.onClassClause().tableName()));
    }

    private Collection<SimpleTableSegment> getTableFromPrivilegeClause(SQLServerStatementParser.ClassTypePrivilegesClauseContext ctx) {
        return null == ctx.onClassTypeClause().tableName() ? Collections.emptyList() : Collections.singletonList((SimpleTableSegment)this.visit((ParseTree)ctx.onClassTypeClause().tableName()));
    }

    @Override
    public ASTNode visitCreateUser(SQLServerStatementParser.CreateUserContext ctx) {
        return new CreateUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(SQLServerStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement();
    }

    @Override
    public ASTNode visitDeny(SQLServerStatementParser.DenyContext ctx) {
        DenyUserStatement result = new DenyUserStatement();
        if (null != ctx.classPrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classPrivilegesClause())) {
                result.setTable(each);
            }
        }
        if (null != ctx.classTypePrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classTypePrivilegesClause())) {
                result.setTable(each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDropUser(SQLServerStatementParser.DropUserContext ctx) {
        return new DropUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(SQLServerStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(SQLServerStatementParser.AlterRoleContext ctx) {
        return new AlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(SQLServerStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement();
    }

    @Override
    public ASTNode visitCreateLogin(SQLServerStatementParser.CreateLoginContext ctx) {
        return new CreateLoginStatement();
    }

    @Override
    public ASTNode visitAlterLogin(SQLServerStatementParser.AlterLoginContext ctx) {
        return new AlterLoginStatement();
    }

    @Override
    public ASTNode visitDropLogin(SQLServerStatementParser.DropLoginContext ctx) {
        return new DropLoginStatement();
    }
}

