/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.statement.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.sql.parser.relation.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.sql.parser.relation.segment.select.groupby.engine.GroupByContextEngine;
import org.apache.shardingsphere.sql.parser.relation.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.sql.parser.relation.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.sql.parser.relation.segment.select.orderby.engine.OrderByContextEngine;
import org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.engine.PaginationContextEngine;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.engine.ProjectionsContextEngine;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.sql.parser.relation.statement.impl.CommonSQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.SubqueryPredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public final class SelectSQLStatementContext
extends CommonSQLStatementContext {
    private final ProjectionsContext projectionsContext;
    private final GroupByContext groupByContext;
    private final OrderByContext orderByContext;
    private final PaginationContext paginationContext;
    private final boolean containsSubquery;

    public SelectSQLStatementContext(SelectStatement sqlStatement, GroupByContext groupByContext, OrderByContext orderByContext, ProjectionsContext projectionsContext, PaginationContext paginationContext) {
        super((SQLStatement)sqlStatement);
        this.groupByContext = groupByContext;
        this.orderByContext = orderByContext;
        this.projectionsContext = projectionsContext;
        this.paginationContext = paginationContext;
        this.containsSubquery = this.containsSubquery();
    }

    public SelectSQLStatementContext(RelationMetas relationMetas, String sql, List<Object> parameters, SelectStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.groupByContext = new GroupByContextEngine().createGroupByContext(sqlStatement);
        this.orderByContext = new OrderByContextEngine().createOrderBy(sqlStatement, this.groupByContext);
        this.projectionsContext = new ProjectionsContextEngine(relationMetas).createProjectionsContext(sql, sqlStatement, this.groupByContext, this.orderByContext);
        this.paginationContext = new PaginationContextEngine().createPaginationContext(sqlStatement, this.projectionsContext, parameters);
        this.containsSubquery = this.containsSubquery();
    }

    private boolean containsSubquery() {
        Collection subqueryPredicateSegments = this.getSqlStatement().findSQLSegments(SubqueryPredicateSegment.class);
        for (SubqueryPredicateSegment each : subqueryPredicateSegments) {
            if (each.getAndPredicates().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void setIndexes(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationProjection(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByContext.getItems());
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByContext.getItems());
    }

    private void setIndexForAggregationProjection(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationProjection each : this.projectionsContext.getAggregationProjections()) {
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (String)"Can't find index: %s, please add alias for aggregate selections", (Object[])new Object[]{each});
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
            for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derived.getColumnLabel()), (String)"Can't find index: %s", (Object[])new Object[]{derived});
                derived.setIndex(columnLabelIndexMap.get(derived.getColumnLabel()));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Optional<Integer> itemIndex;
            if (each.getSegment() instanceof IndexOrderByItemSegment) {
                each.setIndex(((IndexOrderByItemSegment)each.getSegment()).getColumnIndex());
                continue;
            }
            if (each.getSegment() instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)each.getSegment()).getColumn().getOwner().isPresent() && (itemIndex = this.projectionsContext.findProjectionIndex(((ColumnOrderByItemSegment)each.getSegment()).getText())).isPresent()) {
                each.setIndex((Integer)itemIndex.get());
                continue;
            }
            Optional<String> alias = this.getAlias(((TextOrderByItemSegment)each.getSegment()).getText());
            String columnLabel = alias.isPresent() ? (String)alias.get() : this.getOrderItemText((TextOrderByItemSegment)each.getSegment());
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s", (Object[])new Object[]{each});
            if (!columnLabelIndexMap.containsKey(columnLabel)) continue;
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private Optional<String> getAlias(String name) {
        if (this.projectionsContext.isUnqualifiedShorthandProjection()) {
            return Optional.absent();
        }
        String rawName = SQLUtil.getExactlyValue((String)name);
        for (Projection each : this.projectionsContext.getProjections()) {
            if (SQLUtil.getExactlyExpression((String)rawName).equalsIgnoreCase(SQLUtil.getExactlyExpression((String)SQLUtil.getExactlyValue((String)each.getExpression())))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase((String)each.getAlias().orNull())) continue;
            return Optional.of((Object)rawName);
        }
        return Optional.absent();
    }

    private String getOrderItemText(TextOrderByItemSegment orderByItemSegment) {
        return orderByItemSegment instanceof ColumnOrderByItemSegment ? ((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getName() : ((ExpressionOrderByItemSegment)orderByItemSegment).getExpression();
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.groupByContext.getItems().isEmpty() && this.groupByContext.getItems().equals(this.orderByContext.getItems());
    }

    public ProjectionsContext getProjectionsContext() {
        return this.projectionsContext;
    }

    public GroupByContext getGroupByContext() {
        return this.groupByContext;
    }

    public OrderByContext getOrderByContext() {
        return this.orderByContext;
    }

    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    public boolean isContainsSubquery() {
        return this.containsSubquery;
    }

    @Override
    public String toString() {
        return "SelectSQLStatementContext(super=" + super.toString() + ", projectionsContext=" + this.getProjectionsContext() + ", groupByContext=" + this.getGroupByContext() + ", orderByContext=" + this.getOrderByContext() + ", paginationContext=" + this.getPaginationContext() + ", containsSubquery=" + this.isContainsSubquery() + ")";
    }
}

