/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.segment.select.projection.engine;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.sql.parser.relation.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.sql.parser.relation.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.sql.parser.relation.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.engine.ProjectionEngine;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.sql.parser.relation.segment.table.Table;
import org.apache.shardingsphere.sql.parser.relation.segment.table.TablesContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.SelectItemsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;

public final class ProjectionsContextEngine {
    private final RelationMetas relationMetas;
    private final ProjectionEngine selectItemEngine = new ProjectionEngine();

    public ProjectionsContext createProjectionsContext(String sql, SelectStatement selectStatement, GroupByContext groupByContext, OrderByContext orderByContext) {
        SelectItemsSegment selectItemsSegment = selectStatement.getSelectItems();
        Collection<Projection> projections = this.getProjections(sql, selectItemsSegment);
        ProjectionsContext result = new ProjectionsContext(selectItemsSegment.getStartIndex(), selectItemsSegment.getStopIndex(), selectItemsSegment.isDistinctRow(), projections, this.getColumnLabels(selectStatement.getTables(), projections));
        TablesContext tablesContext = new TablesContext((SQLStatement)selectStatement);
        result.getProjections().addAll(this.getDerivedGroupByColumns(tablesContext, projections, groupByContext));
        result.getProjections().addAll(this.getDerivedOrderByColumns(tablesContext, projections, orderByContext));
        return result;
    }

    private Collection<Projection> getProjections(String sql, SelectItemsSegment selectItemsSegment) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        for (SelectItemSegment each : selectItemsSegment.getSelectItems()) {
            Optional<Projection> selectItem = this.selectItemEngine.createProjection(sql, each);
            if (!selectItem.isPresent()) continue;
            result.add((Projection)selectItem.get());
        }
        return result;
    }

    private List<String> getColumnLabels(Collection<TableSegment> tables, Collection<Projection> projections) {
        ArrayList<String> result = new ArrayList<String>(projections.size());
        for (Projection each : projections) {
            if (each instanceof ShorthandProjection) {
                result.addAll(this.getShorthandColumnLabels(tables, (ShorthandProjection)each));
                continue;
            }
            result.add(each.getColumnLabel());
        }
        return result;
    }

    private Collection<String> getShorthandColumnLabels(Collection<TableSegment> tables, ShorthandProjection shorthandProjection) {
        return shorthandProjection.getOwner().isPresent() ? this.getQualifiedShorthandColumnLabels(tables, (String)shorthandProjection.getOwner().get()) : this.getUnqualifiedShorthandColumnLabels(tables);
    }

    private Collection<String> getQualifiedShorthandColumnLabels(Collection<TableSegment> tables, String owner) {
        for (TableSegment each : tables) {
            if (!owner.equalsIgnoreCase((String)each.getAlias().or((Object)each.getTableName()))) continue;
            return this.relationMetas.getAllColumnNames(each.getTableName());
        }
        return Collections.emptyList();
    }

    private Collection<String> getUnqualifiedShorthandColumnLabels(Collection<TableSegment> tables) {
        LinkedList<String> result = new LinkedList<String>();
        for (TableSegment each : tables) {
            result.addAll(this.relationMetas.getAllColumnNames(each.getTableName()));
        }
        return result;
    }

    private Collection<Projection> getDerivedGroupByColumns(TablesContext tablesContext, Collection<Projection> selectItems, GroupByContext groupByContext) {
        return this.getDerivedOrderColumns(tablesContext, selectItems, groupByContext.getItems(), DerivedColumn.GROUP_BY_ALIAS);
    }

    private Collection<Projection> getDerivedOrderByColumns(TablesContext tablesContext, Collection<Projection> selectItems, OrderByContext orderByContext) {
        return this.getDerivedOrderColumns(tablesContext, selectItems, orderByContext.getItems(), DerivedColumn.ORDER_BY_ALIAS);
    }

    private Collection<Projection> getDerivedOrderColumns(TablesContext tablesContext, Collection<Projection> selectItems, Collection<OrderByItem> orderItems, DerivedColumn derivedColumn) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        int derivedColumnOffset = 0;
        for (OrderByItem each : orderItems) {
            if (this.containsProjection(tablesContext, selectItems, each.getSegment())) continue;
            result.add(new DerivedProjection(((TextOrderByItemSegment)each.getSegment()).getText(), derivedColumn.getDerivedColumnAlias(derivedColumnOffset++)));
        }
        return result;
    }

    private boolean containsProjection(TablesContext tablesContext, Collection<Projection> projections, OrderByItemSegment orderByItemSegment) {
        return orderByItemSegment instanceof IndexOrderByItemSegment || this.containsItemInShorthandProjection(tablesContext, projections, orderByItemSegment) || this.containsProjection(projections, orderByItemSegment);
    }

    private boolean containsProjection(Collection<Projection> projections, OrderByItemSegment orderItem) {
        for (Projection each : projections) {
            if (orderItem instanceof IndexOrderByItemSegment) {
                return true;
            }
            if (!this.isSameAlias(each, (TextOrderByItemSegment)orderItem) && !this.isSameQualifiedName(each, (TextOrderByItemSegment)orderItem)) continue;
            return true;
        }
        return false;
    }

    private boolean containsItemInShorthandProjection(TablesContext tablesContext, Collection<Projection> projections, OrderByItemSegment orderByItemSegment) {
        return this.isUnqualifiedShorthandProjection(projections) || this.containsItemWithOwnerInShorthandProjections(tablesContext, projections, orderByItemSegment) || this.containsItemWithoutOwnerInShorthandProjections(tablesContext, projections, orderByItemSegment);
    }

    private boolean isUnqualifiedShorthandProjection(Collection<Projection> projections) {
        if (1 != projections.size()) {
            return false;
        }
        Projection projection = projections.iterator().next();
        return projection instanceof ShorthandProjection && !((ShorthandProjection)projection).getOwner().isPresent();
    }

    private boolean containsItemWithOwnerInShorthandProjections(TablesContext tablesContext, Collection<Projection> projections, OrderByItemSegment orderItem) {
        return orderItem instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().isPresent() && this.findShorthandProjection(tablesContext, projections, ((TableSegment)((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().get()).getTableName()).isPresent();
    }

    private Optional<ShorthandProjection> findShorthandProjection(TablesContext tablesContext, Collection<Projection> projections, String tableNameOrAlias) {
        Optional<Table> table = tablesContext.find(tableNameOrAlias);
        if (!table.isPresent()) {
            return Optional.absent();
        }
        for (Projection each : projections) {
            ShorthandProjection shorthandSelectItem;
            if (!(each instanceof ShorthandProjection) || !(shorthandSelectItem = (ShorthandProjection)each).getOwner().isPresent() || !tablesContext.find((String)shorthandSelectItem.getOwner().get()).equals(table)) continue;
            return Optional.of((Object)shorthandSelectItem);
        }
        return Optional.absent();
    }

    private boolean containsItemWithoutOwnerInShorthandProjections(TablesContext tablesContext, Collection<Projection> projections, OrderByItemSegment orderItem) {
        if (!(orderItem instanceof ColumnOrderByItemSegment)) {
            return false;
        }
        if (!((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().isPresent()) {
            for (ShorthandProjection each : this.getQualifiedShorthandProjections(projections)) {
                if (!this.isSameProjection(tablesContext, each, (ColumnOrderByItemSegment)orderItem)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<ShorthandProjection> getQualifiedShorthandProjections(Collection<Projection> projections) {
        LinkedList<ShorthandProjection> result = new LinkedList<ShorthandProjection>();
        for (Projection each : projections) {
            if (!(each instanceof ShorthandProjection) || !((ShorthandProjection)each).getOwner().isPresent()) continue;
            result.add((ShorthandProjection)each);
        }
        return result;
    }

    private boolean isSameProjection(TablesContext tablesContext, ShorthandProjection shorthandProjection, ColumnOrderByItemSegment orderItem) {
        Preconditions.checkState((boolean)shorthandProjection.getOwner().isPresent());
        Optional<Table> table = tablesContext.find((String)shorthandProjection.getOwner().get());
        return table.isPresent() && this.relationMetas.containsColumn(((Table)table.get()).getName(), orderItem.getColumn().getName());
    }

    private boolean isSameAlias(Projection projection, TextOrderByItemSegment orderItem) {
        return projection.getAlias().isPresent() && (orderItem.getText().equalsIgnoreCase((String)projection.getAlias().get()) || orderItem.getText().equalsIgnoreCase(projection.getExpression()));
    }

    private boolean isSameQualifiedName(Projection projection, TextOrderByItemSegment orderItem) {
        return !projection.getAlias().isPresent() && projection.getExpression().equalsIgnoreCase(orderItem.getText());
    }

    @ConstructorProperties(value={"relationMetas"})
    public ProjectionsContextEngine(RelationMetas relationMetas) {
        this.relationMetas = relationMetas;
    }
}

