/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression;

import com.google.common.base.Optional;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.impl.CommonExpressionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.impl.LiteralExpressionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.impl.ParameterMarkerExpressionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select.SubqueryExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class ExpressionExtractor
implements OptionalSQLSegmentExtractor {
    private final ParameterMarkerExpressionExtractor parameterMarkerExpressionExtractor = new ParameterMarkerExpressionExtractor();
    private final LiteralExpressionExtractor literalExpressionExtractor = new LiteralExpressionExtractor();
    private final CommonExpressionExtractor commonExpressionExtractor = new CommonExpressionExtractor();

    public Optional<? extends ExpressionSegment> extract(ParserRuleContext expressionNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> subqueryNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.SUBQUERY);
        if (subqueryNode.isPresent()) {
            return new SubqueryExtractor().extract((ParserRuleContext)subqueryNode.get(), parameterMarkerIndexes);
        }
        Optional<ParameterMarkerExpressionSegment> parameterMarkerExpressionSegment = this.parameterMarkerExpressionExtractor.extract(expressionNode, parameterMarkerIndexes);
        if (parameterMarkerExpressionSegment.isPresent()) {
            return parameterMarkerExpressionSegment;
        }
        Optional<LiteralExpressionSegment> literalExpressionSegment = this.literalExpressionExtractor.extract(expressionNode, parameterMarkerIndexes);
        if (literalExpressionSegment.isPresent()) {
            return literalExpressionSegment;
        }
        return this.commonExpressionExtractor.extract(expressionNode, parameterMarkerIndexes);
    }
}

