/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.insert;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.InsertColumnsSegment;

public final class InsertColumnsExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnExtractor columnExtractor = new ColumnExtractor();

    public Optional<InsertColumnsSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> insertValuesClause = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.INSERT_VALUES_CLAUSE);
        return insertValuesClause.isPresent() ? Optional.of((Object)new InsertColumnsSegment(((ParserRuleContext)insertValuesClause.get()).getStart().getStartIndex(), this.extractStopIndex((ParserRuleContext)insertValuesClause.get()), this.extractColumns((ParserRuleContext)insertValuesClause.get(), parameterMarkerIndexes))) : Optional.absent();
    }

    private Collection<ColumnSegment> extractColumns(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.COLUMN_NAME)) {
            Optional<ColumnSegment> columnSegment = this.columnExtractor.extract(each, parameterMarkerIndexes);
            if (!columnSegment.isPresent()) continue;
            result.add((ColumnSegment)columnSegment.get());
        }
        return result;
    }

    private int extractStopIndex(ParserRuleContext insertValuesClause) {
        Optional<ParserRuleContext> columnNames = ExtractorUtils.findFirstChildNode(insertValuesClause, RuleName.COLUMN_NAMES);
        if (columnNames.isPresent()) {
            return ((ParserRuleContext)columnNames.get()).getStop().getStopIndex();
        }
        return insertValuesClause.getStart().getStartIndex() - 1;
    }
}

