/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.impl;

import com.google.common.base.Optional;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public final class LiteralExpressionExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<LiteralExpressionSegment> extract(ParserRuleContext expressionNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> literalsNode = ExtractorUtils.findSingleNodeFromFirstDescendant(expressionNode, RuleName.LITERALS);
        if (!literalsNode.isPresent()) {
            return Optional.absent();
        }
        Optional<?> literals = this.getLiterals((ParserRuleContext)literalsNode.get());
        return literals.isPresent() ? Optional.of((Object)new LiteralExpressionSegment(((ParserRuleContext)literalsNode.get()).getStart().getStartIndex(), ((ParserRuleContext)literalsNode.get()).getStop().getStopIndex(), literals.get())) : Optional.absent();
    }

    private Optional<?> getLiterals(ParserRuleContext literalsNode) {
        Optional<Number> numberLiterals = this.getNumberLiterals(literalsNode);
        if (numberLiterals.isPresent()) {
            return numberLiterals;
        }
        return this.getStringLiterals(literalsNode);
    }

    private Optional<Number> getNumberLiterals(ParserRuleContext literalsNode) {
        Optional<ParserRuleContext> numberLiteralsNode = ExtractorUtils.findFirstChildNode(literalsNode, RuleName.NUMBER_LITERALS);
        return numberLiteralsNode.isPresent() ? Optional.of((Object)SQLUtil.getExactlyNumber(((ParserRuleContext)numberLiteralsNode.get()).getText(), 10)) : Optional.absent();
    }

    private Optional<String> getStringLiterals(ParserRuleContext literalsNode) {
        Optional<ParserRuleContext> stringLiteralsNode = ExtractorUtils.findFirstChildNode(literalsNode, RuleName.STRING_LITERALS);
        if (stringLiteralsNode.isPresent()) {
            String text = ((ParserRuleContext)stringLiteralsNode.get()).getText();
            return Optional.of((Object)text.substring(1, text.length() - 1));
        }
        return Optional.absent();
    }
}

