/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.engine;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;

public final class TopPaginationContextEngine {
    public PaginationContext createPaginationContext(TopProjectionSegment topProjectionSegment, Collection<AndPredicate> andPredicates, List<Object> parameters) {
        Optional<PredicateSegment> rowNumberPredicate = this.getRowNumberPredicate(andPredicates, topProjectionSegment.getAlias());
        Optional<Object> offset = rowNumberPredicate.isPresent() ? this.createOffsetWithRowNumber(rowNumberPredicate.get()) : Optional.empty();
        RowNumberValueSegment rowCount = topProjectionSegment.getTop();
        return new PaginationContext(offset.orElse(null), (PaginationValueSegment)rowCount, parameters);
    }

    private Optional<PredicateSegment> getRowNumberPredicate(Collection<AndPredicate> andPredicates, String rowNumberAlias) {
        for (AndPredicate each : andPredicates) {
            for (PredicateSegment predicate : each.getPredicates()) {
                if (!this.isRowNumberColumn(predicate, rowNumberAlias) || !this.isCompareCondition(predicate)) continue;
                return Optional.of(predicate);
            }
        }
        return Optional.empty();
    }

    private boolean isRowNumberColumn(PredicateSegment predicate, String rowNumberAlias) {
        return predicate.getColumn().getIdentifier().getValue().equalsIgnoreCase(rowNumberAlias);
    }

    private boolean isCompareCondition(PredicateSegment predicate) {
        if (predicate.getRightValue() instanceof PredicateCompareRightValue) {
            String operator = ((PredicateCompareRightValue)predicate.getRightValue()).getOperator();
            return ">".equals(operator) || ">=".equals(operator);
        }
        return false;
    }

    private Optional<PaginationValueSegment> createOffsetWithRowNumber(PredicateSegment predicateSegment) {
        ExpressionSegment expression = ((PredicateCompareRightValue)predicateSegment.getRightValue()).getExpression();
        switch (((PredicateCompareRightValue)predicateSegment.getRightValue()).getOperator()) {
            case ">": {
                return Optional.of(this.createRowNumberValueSegment(expression, false));
            }
            case ">=": {
                return Optional.of(this.createRowNumberValueSegment(expression, true));
            }
        }
        return Optional.empty();
    }

    private RowNumberValueSegment createRowNumberValueSegment(ExpressionSegment expression, boolean boundOpened) {
        int startIndex = expression.getStartIndex();
        int stopIndex = expression.getStopIndex();
        return expression instanceof LiteralExpressionSegment ? new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, (long)((Integer)((LiteralExpressionSegment)expression).getLiterals()).intValue(), boundOpened) : new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex(), boundOpened);
    }
}

