/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.metadata.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.sql.parser.binder.metadata.table.TableMetaData;

public final class SchemaMetaData {
    private final Map<String, TableMetaData> tables;

    public SchemaMetaData(Map<String, TableMetaData> tables) {
        this.tables = new ConcurrentHashMap<String, TableMetaData>(tables.size(), 1.0f);
        for (Map.Entry<String, TableMetaData> entry : tables.entrySet()) {
            this.tables.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    public Collection<String> getAllTableNames() {
        return this.tables.keySet();
    }

    public TableMetaData get(String tableName) {
        return this.tables.get(tableName.toLowerCase());
    }

    public void merge(SchemaMetaData schemaMetaData) {
        this.tables.putAll(schemaMetaData.tables);
    }

    public void put(String tableName, TableMetaData tableMetaData) {
        this.tables.put(tableName.toLowerCase(), tableMetaData);
    }

    public void remove(String tableName) {
        this.tables.remove(tableName.toLowerCase());
    }

    public boolean containsTable(String tableName) {
        return this.tables.containsKey(tableName.toLowerCase());
    }

    public boolean containsColumn(String tableName, String columnName) {
        return this.containsTable(tableName) && this.get(tableName).getColumns().containsKey(columnName.toLowerCase());
    }

    public List<String> getAllColumnNames(String tableName) {
        return this.containsTable(tableName) ? new ArrayList<String>(this.get(tableName).getColumns().keySet()) : Collections.emptyList();
    }
}

