/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client.http;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.AddressResolverConfig;
import org.apache.servicecomb.foundation.vertx.SharedVertxFactory;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.client.ClientVerticle;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientOptionsSPI;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClients {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClients.class);
    private static final Map<String, ClientPoolManager<HttpClientWithContext>> httpClients = new HashMap<String, ClientPoolManager<HttpClientWithContext>>();

    public static void load() {
        List clientOptionsList = SPIServiceUtils.getOrLoadSortedService(HttpClientOptionsSPI.class);
        clientOptionsList.forEach(option -> {
            if (option.enabled()) {
                ClientPoolManager<HttpClientWithContext> clientPoolManager = httpClients.get(option.clientName());
                if (clientPoolManager != null) {
                    LOGGER.warn("client pool {} initialized again.", (Object)option.clientName());
                }
                httpClients.put(option.clientName(), HttpClients.createClientPoolManager(option));
            }
        });
    }

    @VisibleForTesting
    public static void mockClientPoolManager(String name, ClientPoolManager<HttpClientWithContext> clientPool) {
        httpClients.put(name, clientPool);
    }

    public static void addNewClientPoolManager(HttpClientOptionsSPI option) {
        httpClients.put(option.clientName(), HttpClients.createClientPoolManager(option));
    }

    public static void destroy() {
        httpClients.clear();
        List clientOptionsList = SPIServiceUtils.getOrLoadSortedService(HttpClientOptionsSPI.class);
        clientOptionsList.forEach(option -> VertxUtils.blockCloseVertxByName(option.clientName()));
    }

    private static ClientPoolManager<HttpClientWithContext> createClientPoolManager(HttpClientOptionsSPI option) {
        Vertx vertx = HttpClients.getOrCreateVertx(option);
        ClientPoolManager<HttpClientWithContext> clientPoolManager = new ClientPoolManager<HttpClientWithContext>(vertx, new HttpClientPoolFactory(HttpClientOptionsSPI.createHttpClientOptions(option)));
        DeploymentOptions deployOptions = VertxUtils.createClientDeployOptions(clientPoolManager, option.getInstanceCount()).setWorker(option.isWorker()).setWorkerPoolName(option.getWorkerPoolName()).setWorkerPoolSize(option.getWorkerPoolSize());
        try {
            VertxUtils.blockDeploy(vertx, ClientVerticle.class, deployOptions);
            return clientPoolManager;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Vertx getOrCreateVertx(HttpClientOptionsSPI option) {
        if (option.useSharedVertx()) {
            return SharedVertxFactory.getSharedVertx();
        }
        AddressResolverOptions resolverOptions = AddressResolverConfig.getAddressResover(option.getConfigTag(), (Configuration)option.getConfigReader());
        VertxOptions vertxOptions = new VertxOptions().setAddressResolverOptions(resolverOptions).setEventLoopPoolSize(option.getEventLoopPoolSize());
        return VertxUtils.getOrCreateVertxByName(option.clientName(), vertxOptions);
    }

    public static HttpClientWithContext getClient(String clientName) {
        ClientPoolManager<HttpClientWithContext> poolManager = httpClients.get(clientName);
        if (poolManager == null) {
            LOGGER.error("client name [{}] not exists, should only happen in tests.", (Object)clientName);
            return null;
        }
        return poolManager.findThreadBindClientPool();
    }

    public static HttpClientWithContext getClient(String clientName, boolean sync) {
        ClientPoolManager<HttpClientWithContext> poolManager = httpClients.get(clientName);
        if (poolManager == null) {
            LOGGER.error("client name [{}] not exists, should only happen in tests.", (Object)clientName);
            return null;
        }
        return poolManager.findClientPool(sync);
    }

    public static HttpClientWithContext getClient(String clientName, boolean sync, Context targetContext) {
        ClientPoolManager<HttpClientWithContext> poolManager = httpClients.get(clientName);
        if (poolManager == null) {
            LOGGER.error("client name [{}] not exists, should only happen in tests.", (Object)clientName);
            return null;
        }
        return poolManager.findClientPool(sync, targetContext);
    }
}

