/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLManager;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLOptionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxTLSBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxTLSBuilder.class);
    private static final String STORE_PKCS12 = "PKCS12";
    private static final String STORE_JKS = "JKS";

    private VertxTLSBuilder() {
    }

    public static NetServerOptions buildNetServerOptions(SSLOption sslOption, SSLCustom sslCustom, NetServerOptions netServerOptions) {
        VertxTLSBuilder.buildTCPSSLOptions(sslOption, sslCustom, (TCPSSLOptions)netServerOptions);
        if (sslOption.isAuthPeer()) {
            netServerOptions.setClientAuth(ClientAuth.REQUIRED);
        } else {
            netServerOptions.setClientAuth(ClientAuth.REQUEST);
        }
        return netServerOptions;
    }

    public static void buildHttpClientOptions(String sslKey, HttpClientOptions httpClientOptions) {
        SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)sslKey, null);
        SSLOption sslOption = factory == null ? SSLOption.buildFromYaml((String)sslKey) : factory.createSSLOption();
        SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
        VertxTLSBuilder.buildHttpClientOptions(sslOption, sslCustom, httpClientOptions);
    }

    public static HttpClientOptions buildHttpClientOptions(SSLOption sslOption, SSLCustom sslCustom, HttpClientOptions httpClientOptions) {
        VertxTLSBuilder.buildClientOptionsBase(sslOption, sslCustom, (ClientOptionsBase)httpClientOptions);
        httpClientOptions.setVerifyHost(sslOption.isCheckCNHost());
        return httpClientOptions;
    }

    public static ClientOptionsBase buildClientOptionsBase(SSLOption sslOption, SSLCustom sslCustom, ClientOptionsBase clientOptionsBase) {
        VertxTLSBuilder.buildTCPSSLOptions(sslOption, sslCustom, (TCPSSLOptions)clientOptionsBase);
        if (sslOption.isAuthPeer()) {
            clientOptionsBase.setTrustAll(false);
        } else {
            clientOptionsBase.setTrustAll(true);
        }
        return clientOptionsBase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TCPSSLOptions buildTCPSSLOptions(SSLOption sslOption, SSLCustom sslCustom, TCPSSLOptions tcpClientOptions) {
        String fullKeyStore;
        tcpClientOptions.setSsl(true);
        if (sslOption.getEngine().equalsIgnoreCase("openssl")) {
            OpenSSLEngineOptions options = new OpenSSLEngineOptions();
            options.setSessionCacheEnabled(true);
            tcpClientOptions.setOpenSslEngineOptions(new OpenSSLEngineOptions());
        }
        if (VertxTLSBuilder.isFileExists(fullKeyStore = sslCustom.getFullPath(sslOption.getKeyStore()))) {
            if (STORE_PKCS12.equalsIgnoreCase(sslOption.getKeyStoreType())) {
                PfxOptions keyPfxOptions = new PfxOptions();
                keyPfxOptions.setPath(fullKeyStore);
                keyPfxOptions.setPassword(new String(sslCustom.decode(sslOption.getKeyStoreValue().toCharArray())));
                tcpClientOptions.setPfxKeyCertOptions(keyPfxOptions);
            } else {
                if (!STORE_JKS.equalsIgnoreCase(sslOption.getKeyStoreType())) throw new IllegalArgumentException("invalid key store type.");
                JksOptions keyJksOptions = new JksOptions();
                keyJksOptions.setPath(fullKeyStore);
                keyJksOptions.setPassword(new String(sslCustom.decode(sslOption.getKeyStoreValue().toCharArray())));
                tcpClientOptions.setKeyStoreOptions(keyJksOptions);
            }
        } else {
            LOGGER.warn("keyStore [" + fullKeyStore + "] file not exist, please check!");
        }
        String fullTrustStore = sslCustom.getFullPath(sslOption.getTrustStore());
        if (VertxTLSBuilder.isFileExists(fullTrustStore)) {
            if (STORE_PKCS12.equalsIgnoreCase(sslOption.getTrustStoreType())) {
                PfxOptions trustPfxOptions = new PfxOptions();
                trustPfxOptions.setPath(fullTrustStore);
                trustPfxOptions.setPassword(new String(sslCustom.decode(sslOption.getTrustStoreValue().toCharArray())));
                tcpClientOptions.setPfxTrustOptions(trustPfxOptions);
            } else {
                if (!STORE_JKS.equalsIgnoreCase(sslOption.getTrustStoreType())) throw new IllegalArgumentException("invalid trust store type.");
                JksOptions trustJksOptions = new JksOptions();
                trustJksOptions.setPath(fullTrustStore);
                trustJksOptions.setPassword(new String(sslCustom.decode(sslOption.getTrustStoreValue().toCharArray())));
                tcpClientOptions.setTrustStoreOptions(trustJksOptions);
            }
        } else {
            LOGGER.warn("trustStore [" + fullTrustStore + "] file not exist, please check!");
        }
        tcpClientOptions.setEnabledSecureTransportProtocols(new HashSet<String>(Arrays.asList(sslOption.getProtocols().split(","))));
        for (String cipher : SSLManager.getEnabledCiphers((String)sslOption.getCiphers())) {
            tcpClientOptions.addEnabledCipherSuite(cipher);
        }
        if (!VertxTLSBuilder.isFileExists(sslCustom.getFullPath(sslOption.getCrl()))) return tcpClientOptions;
        tcpClientOptions.addCrlPath(sslCustom.getFullPath(sslOption.getCrl()));
        return tcpClientOptions;
    }

    private static boolean isFileExists(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        File f = new File(name);
        if (f.isFile()) {
            return true;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader() == null ? VertxTLSBuilder.class.getClassLoader() : Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(name);
        return resource != null;
    }
}

