/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.spring;

import java.util.Map;
import java.util.Properties;
import org.apache.servicecomb.foundation.common.config.PaaSResourceUtils;
import org.apache.servicecomb.foundation.common.utils.FortifyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class PaasNamespaceHandler
extends NamespaceHandlerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaasNamespaceHandler.class);
    private static final String NAMESPACE_RES = "classpath*:META-INF/spring/namespace.properties";

    public void init() {
        Properties properties = null;
        try {
            properties = PaaSResourceUtils.loadMergedProperties(NAMESPACE_RES);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load namespace handler define, {}, {}", (Object)NAMESPACE_RES, (Object)FortifyUtils.getErrorInfo(e));
            return;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String className = entry.getValue().toString();
            try {
                Class<?> clazz = Class.forName(className);
                Object instance = clazz.newInstance();
                this.registerBeanDefinitionParser(entry.getKey().toString(), (BeanDefinitionParser)instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.info("Failed to create BeanDefinitionParser instance of {}", (Object)className);
            }
        }
    }
}

