/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.net;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.servicecomb.foundation.common.net.IpPort;

public class URIEndpointObject
extends IpPort {
    private static final String SSL_ENABLED_KEY = "sslEnabled";
    private static final String PROTOCOL_KEY = "protocol";
    private static final String HTTP2 = "http2";
    private boolean sslEnabled;
    private boolean http2Enabled;
    private Map<String, List<String>> querys;

    public URIEndpointObject(String endpoint) {
        URI uri = URI.create(endpoint);
        this.setHostOrIp(uri.getHost());
        if (uri.getPort() < 0) {
            throw new IllegalArgumentException("port not specified.");
        }
        this.setPort(uri.getPort());
        this.querys = URIEndpointObject.splitQuery(uri);
        this.sslEnabled = Boolean.parseBoolean(this.getFirst(SSL_ENABLED_KEY));
        String httpVersion = this.getFirst(PROTOCOL_KEY);
        if (HTTP2.equals(httpVersion)) {
            this.http2Enabled = true;
        }
    }

    public static Map<String, List<String>> splitQuery(URI uri) {
        LinkedHashMap<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();
        List pairs = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
        for (NameValuePair pair : pairs) {
            List list = queryPairs.computeIfAbsent(pair.getName(), name -> new ArrayList());
            list.add(pair.getValue());
        }
        return queryPairs;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    public List<String> getQuery(String key) {
        return this.querys.get(key);
    }

    public String getFirst(String key) {
        List<String> values = this.querys.get(key);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }
}

