/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.socket.source;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.socket.config.SocketSinkConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.socket.exception.SocketConnectorException;
import org.apache.seatunnel.connectors.seatunnel.socket.source.SocketSourceParameter;
import org.apache.seatunnel.connectors.seatunnel.socket.source.SocketSourceReader;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class SocketSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private SocketSourceParameter parameter;
    private JobContext jobContext;

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public String getPluginName() {
        return "Socket";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{SocketSinkConfigOptions.PORT.key(), SocketSinkConfigOptions.HOST.key()});
        if (!result.isSuccess()) {
            throw new SocketConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, result.getMsg()));
        }
        this.parameter = new SocketSourceParameter(pluginConfig);
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return new SeaTunnelRowType(new String[]{"value"}, new SeaTunnelDataType[]{BasicType.STRING_TYPE});
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new SocketSourceReader(this.parameter, readerContext);
    }
}

