/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import com.google.auto.service.AutoService;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver.SqlServerType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlServerTypeConverter;

@Deprecated
@AutoService(value={DataTypeConvertor.class})
public class SqlServerDataTypeConvertor
implements DataTypeConvertor<SqlServerType> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final String LENGTH = "length";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;

    public SeaTunnelDataType<?> toSeaTunnelType(String field, @NonNull String connectorDataType) {
        if (connectorDataType == null) {
            throw new NullPointerException("connectorDataType is marked non-null but is null");
        }
        Pair<SqlServerType, Map<String, Object>> sqlServerType = SqlServerType.parse(connectorDataType);
        return this.toSeaTunnelType(field, (SqlServerType)sqlServerType.getLeft(), (Map<String, Object>)((Map)sqlServerType.getRight()));
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, @NonNull SqlServerType connectorDataType, Map<String, Object> dataTypeProperties) {
        if (connectorDataType == null) {
            throw new NullPointerException("connectorDataType is marked non-null but is null");
        }
        int precision = Integer.parseInt(dataTypeProperties.getOrDefault(PRECISION, DEFAULT_PRECISION).toString());
        long length = Long.parseLong(dataTypeProperties.getOrDefault(LENGTH, 0).toString());
        int scale = (Integer)dataTypeProperties.getOrDefault(SCALE, DEFAULT_SCALE);
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(field).columnType(connectorDataType.getSqlTypeName()).dataType(connectorDataType.getSqlTypeName()).length(Long.valueOf(length)).precision(Long.valueOf(precision)).scale(Integer.valueOf(scale)).build();
        return SqlServerTypeConverter.INSTANCE.convert(typeDefine).getDataType();
    }

    public SqlServerType toConnectorType(String field, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        Long precision = MapUtils.getLong(dataTypeProperties, (Object)PRECISION);
        Integer scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE);
        PhysicalColumn column = PhysicalColumn.builder().name(field).dataType(seaTunnelDataType).columnLength(precision).scale(scale).nullable(true).build();
        BasicTypeDefine typeDefine = SqlServerTypeConverter.INSTANCE.reconvert((Column)column);
        return (SqlServerType)SqlServerType.parse(typeDefine.getColumnType()).getLeft();
    }

    public String getIdentity() {
        return "SqlServer";
    }
}

