/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.offset;

import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.jdbc.JdbcConnection;
import java.util.Map;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.config.SqlServerSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.config.SqlServerSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.SqlServerDialect;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.offset.LsnOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.utils.SqlServerUtils;

public class LsnOffsetFactory
extends OffsetFactory {
    private final SqlServerSourceConfig sourceConfig;
    private final SqlServerDialect dialect;

    public LsnOffsetFactory(SqlServerSourceConfigFactory configFactory, SqlServerDialect dialect) {
        this.sourceConfig = configFactory.create(0);
        this.dialect = dialect;
    }

    public Offset earliest() {
        return LsnOffset.INITIAL_OFFSET;
    }

    public Offset neverStop() {
        return LsnOffset.NO_STOPPING_OFFSET;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Offset latest() {
        try (JdbcConnection jdbcConnection = this.dialect.openJdbcConnection(this.sourceConfig);){
            LsnOffset lsnOffset = SqlServerUtils.currentLsn((SqlServerConnection)jdbcConnection);
            return lsnOffset;
        }
        catch (Exception e) {
            throw new RuntimeException("Read the binlog offset error", e);
        }
    }

    public Offset specific(Map<String, String> offset) {
        return LsnOffset.valueOf(offset.get("commit_lsn"));
    }

    public Offset specific(String filename, Long position) {
        throw new UnsupportedOperationException("not supported create new Offset by filename and position.");
    }

    public Offset timestamp(long timestamp) {
        throw new UnsupportedOperationException("not supported create new Offset by timestamp.");
    }
}

