/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XaFacade;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XaGroupOps;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XaGroupOpsImpl;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.XidInfo;

public class JdbcSinkCommitter
implements SinkCommitter<XidInfo> {
    private final XaFacade xaFacade;
    private final XaGroupOps xaGroupOps;
    private final JdbcConnectionConfig jdbcConnectionConfig;

    public JdbcSinkCommitter(JdbcSinkConfig jdbcSinkConfig) throws IOException {
        this.jdbcConnectionConfig = jdbcSinkConfig.getJdbcConnectionConfig();
        this.xaFacade = XaFacade.fromJdbcConnectionOptions(this.jdbcConnectionConfig);
        this.xaGroupOps = new XaGroupOpsImpl(this.xaFacade);
        try {
            this.xaFacade.open();
        }
        catch (Exception e) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.WRITER_OPERATION_FAILED, "unable to open JDBC sink committer", e);
        }
    }

    public List<XidInfo> commit(List<XidInfo> committables) {
        return this.xaGroupOps.commit(new ArrayList<XidInfo>(committables), false, this.jdbcConnectionConfig.getMaxCommitAttempts()).getForRetry();
    }

    public void abort(List<XidInfo> commitInfos) {
        try {
            this.xaGroupOps.rollback(commitInfos);
        }
        catch (Exception e) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.XA_OPERATION_FAILED, "rollback failed", e);
        }
    }
}

