/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlServerTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlserverJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlserverTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDialect
implements JdbcDialect {
    private static final Logger log = LoggerFactory.getLogger(SqlServerDialect.class);
    public String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public SqlServerDialect() {
    }

    public SqlServerDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "SqlServer";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new SqlserverJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new SqlserverTypeMapper();
    }

    @Override
    public String hashModForField(String fieldName, int mod) {
        return "ABS(HASHBYTES('MD5', " + this.quoteIdentifier(fieldName) + ") % " + mod + ")";
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("[TARGET].%s=[SOURCE].%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("[TARGET].%s=[SOURCE].%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "[SOURCE]." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String upsertSQL = String.format("MERGE INTO %s.%s AS [TARGET] USING (%s) AS [SOURCE] ON (%s) WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s);", this.quoteDatabaseIdentifier(database), this.quoteIdentifier(tableName), usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("[").append(parts[i]).append("]").append(".");
            }
            return sb.append("[").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("]").toString();
        }
        return "[" + this.getFieldIde(identifier, this.fieldIde) + "]";
    }

    @Override
    public String quoteDatabaseIdentifier(String identifier) {
        return "[" + identifier + "]";
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.quoteIdentifier(tablePath.getFullName());
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Long approximateRowCntStatement(Connection connection, JdbcSourceTable table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = this.quoteIdentifier(columnName);
        String sqlQuery = StringUtils.isNotBlank(table.getQuery()) ? String.format("SELECT MAX(%s) FROM (SELECT TOP (%s) %s FROM (%s) AS T1 WHERE %s >= ? ORDER BY %s ASC) AS T2", quotedColumn, chunkSize, quotedColumn, table.getQuery(), quotedColumn, quotedColumn) : String.format("SELECT MAX(%s) FROM (SELECT TOP (%s) %s FROM %s WHERE %s >= ? ORDER BY %s ASC ) AS T", quotedColumn, chunkSize, quotedColumn, this.tableIdentifier(table.getTablePath()), quotedColumn, quotedColumn);
        Throwable throwable = null;
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            Throwable throwable2;
            ResultSet rs;
            block25: {
                Object object;
                block26: {
                    block27: {
                        ps.setObject(1, includedLowerBound);
                        rs = ps.executeQuery();
                        throwable2 = null;
                        if (!rs.next()) break block25;
                        object = rs.getObject(1);
                        if (rs == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    rs.close();
                }
                return object;
            }
            try {
                try {
                    try {
                        throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (rs != null) {
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            rs.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    @Override
    public TypeConverter<BasicTypeDefine> getTypeConverter() {
        return SqlServerTypeConverter.INSTANCE;
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableAddColumnEvent event) throws SQLException {
        ArrayList<String> ddlSQL = new ArrayList<String>();
        Column column = event.getColumn();
        String sourceDialectName = event.getSourceDialectName();
        boolean sameCatalog = StringUtils.equals(this.dialectName(), sourceDialectName);
        BasicTypeDefine typeDefine = (BasicTypeDefine)this.getTypeConverter().reconvert(column);
        String columnType = sameCatalog ? column.getSourceType() : typeDefine.getColumnType();
        StringBuilder sqlBuilder = this.buildAlterTablePrefix(tablePath).append(" ADD ").append(this.quoteIdentifier(column.getName())).append(" ").append(columnType).append(" ");
        if (column.getDefaultValue() != null) {
            String defaultValueClause = this.sqlClauseWithDefaultValue(typeDefine, sourceDialectName);
            sqlBuilder.append(defaultValueClause);
        }
        if (!column.isNullable()) {
            sqlBuilder.append(" NOT NULL");
        }
        ddlSQL.add(sqlBuilder.toString());
        if (column.getComment() != null) {
            ddlSQL.add(this.buildColumnCommentSQL(tablePath, column));
        }
        this.executeDDL(connection, ddlSQL);
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableChangeColumnEvent event) throws SQLException {
        ArrayList<String> ddlSQL = new ArrayList<String>();
        if (event.getOldColumn() != null && !event.getColumn().getName().equals(event.getOldColumn())) {
            StringBuilder sqlBuilder = new StringBuilder().append("EXEC sp_rename ").append(String.format("'%s.%s.%s.%s', ", tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName(), event.getOldColumn())).append(String.format("'%s', 'COLUMN';", event.getColumn().getName()));
            ddlSQL.add(sqlBuilder.toString());
        }
        this.executeDDL(connection, ddlSQL);
        if (event.getColumn().getDataType() != null) {
            this.applySchemaChange(connection, tablePath, AlterTableModifyColumnEvent.modify((TableIdentifier)event.tableIdentifier(), (Column)event.getColumn()));
        }
    }

    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableModifyColumnEvent event) throws SQLException {
        Column column = event.getColumn();
        String sourceDialectName = event.getSourceDialectName();
        boolean sameCatalog = StringUtils.equals(this.dialectName(), sourceDialectName);
        BasicTypeDefine typeDefine = (BasicTypeDefine)this.getTypeConverter().reconvert(column);
        String columnType = sameCatalog ? column.getSourceType() : typeDefine.getColumnType();
        ArrayList<String> ddlSQL = new ArrayList<String>();
        if (column.getDefaultValue() != null) {
            if (sameCatalog || !this.isSpecialDefaultValue(typeDefine.getDefaultValue(), sourceDialectName)) {
                String constraintQuery = String.format("SELECT dc.name AS constraint_name\nFROM sys.default_constraints dc \nJOIN sys.columns c ON dc.parent_object_id = c.object_id AND dc.parent_column_id = c.column_id \nJOIN sys.tables t ON c.object_id = t.object_id \nJOIN sys.schemas s ON t.schema_id = s.schema_id \nWHERE t.name = '%s' AND s.name = '%s' AND c.name = '%s';", tablePath.getTableName(), tablePath.getSchemaName(), event.getColumn().getName());
                try (Statement stmt = connection.createStatement();
                     ResultSet rs = stmt.executeQuery(constraintQuery);){
                    while (rs.next()) {
                        String constraintName = rs.getString(1);
                        if (StringUtils.isBlank(constraintName)) continue;
                        StringBuilder dropConstraintSQL = this.buildAlterTablePrefix(tablePath).append(" DROP CONSTRAINT ").append(this.quoteIdentifier(constraintName));
                        ddlSQL.add(dropConstraintSQL.toString());
                    }
                }
                String defaultValueClause = this.sqlClauseWithDefaultValue(typeDefine, sourceDialectName);
                if (StringUtils.isNotBlank(defaultValueClause)) {
                    StringBuilder defaultSqlBuilder = this.buildAlterTablePrefix(tablePath).append(" ADD ").append(defaultValueClause).append(" FOR ").append(this.quoteIdentifier(column.getName()));
                    ddlSQL.add(defaultSqlBuilder.toString());
                }
            } else {
                log.warn("Skipping unsupported default value for column {} in table {}.", (Object)column.getName(), (Object)tablePath.getFullName());
            }
        }
        if (column.getComment() != null) {
            ddlSQL.add(this.buildColumnCommentSQL(tablePath, column));
        }
        StringBuilder sqlBuilder = this.buildAlterTablePrefix(tablePath).append(" ALTER COLUMN ").append(this.quoteIdentifier(column.getName())).append(" ").append(columnType);
        boolean targetColumnNullable = this.columnIsNullable(connection, tablePath, column.getName());
        if (column.isNullable() != targetColumnNullable && !targetColumnNullable) {
            sqlBuilder.append(" NULL ");
        }
        ddlSQL.add(sqlBuilder.toString());
        this.executeDDL(connection, ddlSQL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableDropColumnEvent event) throws SQLException {
        String constraintQuery = String.format("SELECT dc.name AS constraint_name\nFROM sys.default_constraints dc \nJOIN sys.columns c ON dc.parent_object_id = c.object_id AND dc.parent_column_id = c.column_id \nJOIN sys.tables t ON c.object_id = t.object_id \nJOIN sys.schemas s ON t.schema_id = s.schema_id \nWHERE t.name = '%s' AND c.name = '%s' and s.name = '%s';", tablePath.getTableName(), event.getColumn(), tablePath.getSchemaName());
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(constraintQuery);){
            while (rs.next()) {
                Statement dropStmt;
                block46: {
                    String constraintName = rs.getString(1);
                    String dropConstraintSQL = String.format("ALTER TABLE %s DROP CONSTRAINT %s", this.tableIdentifier(tablePath), this.quoteIdentifier(constraintName));
                    dropStmt = connection.createStatement();
                    Throwable throwable = null;
                    try {
                        log.info("Executing drop constraint SQL: {}", (Object)dropConstraintSQL);
                        dropStmt.execute(dropConstraintSQL);
                        if (dropStmt == null) continue;
                        if (throwable == null) break block46;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (dropStmt == null) throw throwable3;
                            if (throwable == null) {
                                dropStmt.close();
                                throw throwable3;
                            }
                            try {
                                dropStmt.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        dropStmt.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                dropStmt.close();
            }
        }
        String dropColumnSQL = String.format("ALTER TABLE %s DROP COLUMN %s", this.tableIdentifier(tablePath), this.quoteIdentifier(event.getColumn()));
        try (Statement statement = connection.createStatement();){
            log.info("Executing drop column SQL: {}", (Object)dropColumnSQL);
            statement.execute(dropColumnSQL);
            return;
        }
    }

    @Override
    public boolean needsQuotesWithDefaultValue(BasicTypeDefine columnDefine) {
        String sqlServerType;
        switch (sqlServerType = columnDefine.getDataType()) {
            case "CHAR": 
            case "VARCHAR": 
            case "NCHAR": 
            case "NVARCHAR": 
            case "TEXT": 
            case "NTEXT": 
            case "XML": 
            case "UNIQUEIDENTIFIER": 
            case "SQL_VARIANT": {
                return true;
            }
        }
        return false;
    }

    private void executeDDL(Connection connection, List<String> ddlSQL) throws SQLException {
        try (Statement statement = connection.createStatement();){
            for (String sql : ddlSQL) {
                log.info("Executing SqlServer SQL: {}", (Object)sql);
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error executing SqlServer SQL: " + ddlSQL, e.getSQLState(), e);
        }
    }

    private String buildColumnCommentSQL(TablePath tablePath, Column column) {
        return String.format("EXEC %s.sys.sp_updateextendedproperty 'MS_Description', N'%s', 'schema', N'%s', 'table', N'%s', 'column', N'%s';", tablePath.getDatabaseName(), column.getComment(), tablePath.getSchemaName(), tablePath.getTableName(), column.getName());
    }

    private boolean columnIsNullable(Connection connection, TablePath tablePath, String column) throws SQLException {
        String selectColumnSQL = String.format("SELECT IS_NULLABLE FROM information_schema.COLUMNS WHERE %s AND COLUMN_NAME = '%s';", this.buildCommonWhereClause(tablePath), column);
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(selectColumnSQL);
            rs.next();
            boolean bl = rs.getString("IS_NULLABLE").equals("YES");
            return bl;
        }
    }

    private StringBuilder buildAlterTablePrefix(TablePath tablePath) {
        return new StringBuilder("ALTER TABLE ").append(this.tableIdentifier(tablePath));
    }

    private String buildCommonWhereClause(TablePath tablePath) {
        return String.format("TABLE_CATALOG = '%s' AND TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s'", tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName());
    }
}

