/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oceanbase;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.VectorType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oceanbase.OceanBaseMysqlType;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class OceanBaseMySqlTypeConverter
implements TypeConverter<BasicTypeDefine<OceanBaseMysqlType>> {
    private static final Logger log = LoggerFactory.getLogger(OceanBaseMySqlTypeConverter.class);
    static final String MYSQL_NULL = "NULL";
    static final String MYSQL_BIT = "BIT";
    static final String MYSQL_TINYINT = "TINYINT";
    static final String MYSQL_TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    static final String MYSQL_SMALLINT = "SMALLINT";
    static final String MYSQL_SMALLINT_UNSIGNED = "SMALLINT UNSIGNED";
    static final String MYSQL_MEDIUMINT = "MEDIUMINT";
    static final String MYSQL_MEDIUMINT_UNSIGNED = "MEDIUMINT UNSIGNED";
    static final String MYSQL_INT = "INT";
    static final String MYSQL_INT_UNSIGNED = "INT UNSIGNED";
    static final String MYSQL_INTEGER = "INTEGER";
    static final String MYSQL_INTEGER_UNSIGNED = "INTEGER UNSIGNED";
    static final String MYSQL_BIGINT = "BIGINT";
    static final String MYSQL_BIGINT_UNSIGNED = "BIGINT UNSIGNED";
    static final String MYSQL_DECIMAL = "DECIMAL";
    static final String MYSQL_DECIMAL_UNSIGNED = "DECIMAL UNSIGNED";
    static final String MYSQL_FLOAT = "FLOAT";
    static final String MYSQL_FLOAT_UNSIGNED = "FLOAT UNSIGNED";
    static final String MYSQL_DOUBLE = "DOUBLE";
    static final String MYSQL_DOUBLE_UNSIGNED = "DOUBLE UNSIGNED";
    public static final String MYSQL_CHAR = "CHAR";
    public static final String MYSQL_VARCHAR = "VARCHAR";
    static final String MYSQL_TINYTEXT = "TINYTEXT";
    static final String MYSQL_MEDIUMTEXT = "MEDIUMTEXT";
    static final String MYSQL_TEXT = "TEXT";
    static final String MYSQL_LONGTEXT = "LONGTEXT";
    static final String MYSQL_JSON = "JSON";
    static final String MYSQL_ENUM = "ENUM";
    static final String MYSQL_DATE = "DATE";
    public static final String MYSQL_DATETIME = "DATETIME";
    public static final String MYSQL_TIME = "TIME";
    public static final String MYSQL_TIMESTAMP = "TIMESTAMP";
    static final String MYSQL_YEAR = "YEAR";
    static final String MYSQL_TINYBLOB = "TINYBLOB";
    static final String MYSQL_MEDIUMBLOB = "MEDIUMBLOB";
    static final String MYSQL_BLOB = "BLOB";
    static final String MYSQL_LONGBLOB = "LONGBLOB";
    static final String MYSQL_BINARY = "BINARY";
    static final String MYSQL_VARBINARY = "VARBINARY";
    static final String MYSQL_GEOMETRY = "GEOMETRY";
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_PRECISION = 65;
    public static final int DEFAULT_SCALE = 18;
    public static final int MAX_SCALE = 30;
    public static final int MAX_TIME_SCALE = 6;
    public static final int MAX_TIMESTAMP_SCALE = 6;
    public static final long POWER_2_8 = (long)Math.pow(2.0, 8.0);
    public static final long POWER_2_16 = (long)Math.pow(2.0, 16.0);
    public static final long POWER_2_24 = (long)Math.pow(2.0, 24.0);
    public static final long POWER_2_32 = (long)Math.pow(2.0, 32.0);
    public static final long MAX_VARBINARY_LENGTH = POWER_2_16 - 4L;
    private static final String VECTOR_TYPE_NAME = "";
    private static final String VECTOR_NAME = "VECTOR";
    public static final OceanBaseMySqlTypeConverter INSTANCE = new OceanBaseMySqlTypeConverter();

    public String identifier() {
        return "OceanBase";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        String mysqlDataType = typeDefine.getDataType().toUpperCase();
        if (typeDefine.isUnsigned() && !mysqlDataType.endsWith(" UNSIGNED")) {
            mysqlDataType = mysqlDataType + " UNSIGNED";
        }
        switch (mysqlDataType) {
            case "NULL": {
                builder.dataType((SeaTunnelDataType)BasicType.VOID_TYPE);
                break;
            }
            case "BIT": {
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                    break;
                }
                if (typeDefine.getLength() == 1L) {
                    builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                    break;
                }
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                long byteLength = typeDefine.getLength() / 8L;
                builder.columnLength(Long.valueOf(byteLength += typeDefine.getLength() % 8L > 0L ? 1L : 0L));
                break;
            }
            case "TINYINT": {
                if (typeDefine.getColumnType().equalsIgnoreCase("tinyint(1)")) {
                    builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                    break;
                }
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case "TINYINT UNSIGNED": 
            case "SMALLINT": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "SMALLINT UNSIGNED": 
            case "MEDIUMINT": 
            case "MEDIUMINT UNSIGNED": 
            case "INT": 
            case "INTEGER": 
            case "YEAR": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "INT UNSIGNED": 
            case "INTEGER UNSIGNED": 
            case "BIGINT": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "BIGINT UNSIGNED": {
                DecimalType intDecimalType = new DecimalType(20, 0);
                builder.dataType((SeaTunnelDataType)intDecimalType);
                builder.columnLength(Long.valueOf(intDecimalType.getPrecision()));
                builder.scale(Integer.valueOf(intDecimalType.getScale()));
                break;
            }
            case "FLOAT": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "FLOAT UNSIGNED": {
                log.warn("{} will probably cause value overflow.", (Object)MYSQL_FLOAT_UNSIGNED);
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "DOUBLE UNSIGNED": {
                log.warn("{} will probably cause value overflow.", (Object)MYSQL_DOUBLE_UNSIGNED);
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "DECIMAL": {
                DecimalType decimalType;
                Preconditions.checkArgument((typeDefine.getPrecision() > 0L ? 1 : 0) != 0);
                if (typeDefine.getPrecision() > 38L) {
                    log.warn("{} will probably cause value overflow.", (Object)MYSQL_DECIMAL);
                    decimalType = new DecimalType(38, 18);
                } else {
                    decimalType = new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale() == null ? 0 : typeDefine.getScale());
                }
                builder.dataType((SeaTunnelDataType)decimalType);
                builder.columnLength(Long.valueOf(decimalType.getPrecision()));
                builder.scale(Integer.valueOf(decimalType.getScale()));
                break;
            }
            case "DECIMAL UNSIGNED": {
                Preconditions.checkArgument((typeDefine.getPrecision() > 0L ? 1 : 0) != 0);
                log.warn("{} will probably cause value overflow.", (Object)MYSQL_DECIMAL_UNSIGNED);
                DecimalType decimalUnsignedType = new DecimalType(typeDefine.getPrecision().intValue() + 1, typeDefine.getScale() == null ? 0 : typeDefine.getScale());
                builder.dataType((SeaTunnelDataType)decimalUnsignedType);
                builder.columnLength(Long.valueOf(decimalUnsignedType.getPrecision()));
                builder.scale(Integer.valueOf(decimalUnsignedType.getScale()));
                break;
            }
            case "ENUM": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.columnLength(Long.valueOf(100L));
                    break;
                }
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "CHAR": 
            case "VARCHAR": {
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.columnLength(TypeDefineUtils.charTo4ByteLength(1L));
                } else {
                    builder.columnLength(typeDefine.getLength());
                }
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "TINYTEXT": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(POWER_2_8 - 1L));
                break;
            }
            case "TEXT": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(POWER_2_16 - 1L));
                break;
            }
            case "MEDIUMTEXT": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(POWER_2_24 - 1L));
                break;
            }
            case "LONGTEXT": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(POWER_2_32 - 1L));
                break;
            }
            case "JSON": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "BINARY": 
            case "VARBINARY": {
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.columnLength(Long.valueOf(1L));
                } else {
                    builder.columnLength(typeDefine.getLength());
                }
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case "TINYBLOB": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(POWER_2_8 - 1L));
                break;
            }
            case "BLOB": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(POWER_2_16 - 1L));
                break;
            }
            case "MEDIUMBLOB": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(POWER_2_24 - 1L));
                break;
            }
            case "LONGBLOB": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(POWER_2_32 - 1L));
                break;
            }
            case "GEOMETRY": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case "DATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "": {
                String columnType = typeDefine.getColumnType();
                if (!columnType.startsWith("vector(") || !columnType.endsWith(")")) break;
                Integer number = Integer.parseInt(columnType.substring(columnType.indexOf("(") + 1, columnType.indexOf(")")));
                builder.dataType((SeaTunnelDataType)VectorType.VECTOR_FLOAT_TYPE);
                builder.scale(number);
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"OceanBase", (String)mysqlDataType, (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine<OceanBaseMysqlType> reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case NULL: {
                builder.nativeType((Object)OceanBaseMysqlType.NULL);
                builder.columnType(MYSQL_NULL);
                builder.dataType(MYSQL_NULL);
                break;
            }
            case BOOLEAN: {
                builder.nativeType((Object)OceanBaseMysqlType.BOOLEAN);
                builder.columnType(String.format("%s(%s)", MYSQL_TINYINT, 1));
                builder.dataType(MYSQL_TINYINT);
                builder.length(Long.valueOf(1L));
                break;
            }
            case TINYINT: {
                builder.nativeType((Object)OceanBaseMysqlType.TINYINT);
                builder.columnType(MYSQL_TINYINT);
                builder.dataType(MYSQL_TINYINT);
                break;
            }
            case SMALLINT: {
                builder.nativeType((Object)OceanBaseMysqlType.SMALLINT);
                builder.columnType(MYSQL_SMALLINT);
                builder.dataType(MYSQL_SMALLINT);
                break;
            }
            case INT: {
                builder.nativeType((Object)OceanBaseMysqlType.INT);
                builder.columnType(MYSQL_INT);
                builder.dataType(MYSQL_INT);
                break;
            }
            case BIGINT: {
                builder.nativeType((Object)OceanBaseMysqlType.BIGINT);
                builder.columnType(MYSQL_BIGINT);
                builder.dataType(MYSQL_BIGINT);
                break;
            }
            case FLOAT: {
                builder.nativeType((Object)OceanBaseMysqlType.FLOAT);
                builder.columnType(MYSQL_FLOAT);
                builder.dataType(MYSQL_FLOAT);
                break;
            }
            case DOUBLE: {
                builder.nativeType((Object)OceanBaseMysqlType.DOUBLE);
                builder.columnType(MYSQL_DOUBLE);
                builder.dataType(MYSQL_DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 65L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 65L));
                    precision = 65L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 65, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 30) {
                    scale = 30;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 30, precision, scale});
                }
                builder.nativeType((Object)OceanBaseMysqlType.DECIMAL);
                builder.columnType(String.format("%s(%s,%s)", MYSQL_DECIMAL, precision, scale));
                builder.dataType(MYSQL_DECIMAL);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case BYTES: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.nativeType((Object)OceanBaseMysqlType.VARBINARY);
                    builder.columnType(String.format("%s(%s)", MYSQL_VARBINARY, MAX_VARBINARY_LENGTH / 2L));
                    builder.dataType(MYSQL_VARBINARY);
                    break;
                }
                if (column.getColumnLength() < MAX_VARBINARY_LENGTH) {
                    builder.nativeType((Object)OceanBaseMysqlType.VARBINARY);
                    builder.columnType(String.format("%s(%s)", MYSQL_VARBINARY, column.getColumnLength()));
                    builder.dataType(MYSQL_VARBINARY);
                    break;
                }
                if (column.getColumnLength() < POWER_2_24) {
                    builder.nativeType((Object)OceanBaseMysqlType.MEDIUMBLOB);
                    builder.columnType(MYSQL_MEDIUMBLOB);
                    builder.dataType(MYSQL_MEDIUMBLOB);
                    break;
                }
                builder.nativeType((Object)OceanBaseMysqlType.LONGBLOB);
                builder.columnType(MYSQL_LONGBLOB);
                builder.dataType(MYSQL_LONGBLOB);
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.nativeType((Object)OceanBaseMysqlType.LONGTEXT);
                    builder.columnType(MYSQL_LONGTEXT);
                    builder.dataType(MYSQL_LONGTEXT);
                    break;
                }
                if (column.getColumnLength() < POWER_2_8) {
                    builder.nativeType((Object)OceanBaseMysqlType.VARCHAR);
                    builder.columnType(String.format("%s(%s)", MYSQL_VARCHAR, column.getColumnLength()));
                    builder.dataType(MYSQL_VARCHAR);
                    break;
                }
                if (column.getColumnLength() < POWER_2_16) {
                    builder.nativeType((Object)OceanBaseMysqlType.TEXT);
                    builder.columnType(MYSQL_TEXT);
                    builder.dataType(MYSQL_TEXT);
                    break;
                }
                if (column.getColumnLength() < POWER_2_24) {
                    builder.nativeType((Object)OceanBaseMysqlType.MEDIUMTEXT);
                    builder.columnType(MYSQL_MEDIUMTEXT);
                    builder.dataType(MYSQL_MEDIUMTEXT);
                    break;
                }
                builder.nativeType((Object)OceanBaseMysqlType.LONGTEXT);
                builder.columnType(MYSQL_LONGTEXT);
                builder.dataType(MYSQL_LONGTEXT);
                break;
            }
            case DATE: {
                builder.nativeType((Object)OceanBaseMysqlType.DATE);
                builder.columnType(MYSQL_DATE);
                builder.dataType(MYSQL_DATE);
                break;
            }
            case TIME: {
                builder.nativeType((Object)OceanBaseMysqlType.TIME);
                builder.dataType(MYSQL_TIME);
                if (column.getScale() != null && column.getScale() > 0) {
                    int timeScale = column.getScale();
                    if (timeScale > 6) {
                        timeScale = 6;
                        log.warn("The time column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 30, timeScale});
                    }
                    builder.columnType(String.format("%s(%s)", MYSQL_TIME, timeScale));
                    builder.scale(Integer.valueOf(timeScale));
                    break;
                }
                builder.columnType(MYSQL_TIME);
                break;
            }
            case TIMESTAMP: {
                builder.nativeType((Object)OceanBaseMysqlType.DATETIME);
                builder.dataType(MYSQL_DATETIME);
                if (column.getScale() != null && column.getScale() > 0) {
                    int timestampScale = column.getScale();
                    if (timestampScale > 6) {
                        timestampScale = 6;
                        log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 6, timestampScale});
                    }
                    builder.columnType(String.format("%s(%s)", MYSQL_DATETIME, timestampScale));
                    builder.scale(Integer.valueOf(timestampScale));
                    break;
                }
                builder.columnType(MYSQL_DATETIME);
                break;
            }
            case FLOAT_VECTOR: {
                builder.nativeType((Object)VECTOR_NAME);
                builder.columnType(String.format("%s(%s)", VECTOR_NAME, column.getScale()));
                builder.dataType(VECTOR_NAME);
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"OceanBase", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

