/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class JdbcSourceFactory
implements TableSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(JdbcSourceFactory.class);

    public String factoryIdentifier() {
        return "Jdbc";
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        JdbcSourceConfig config = JdbcSourceConfig.of(context.getOptions());
        JdbcDialect jdbcDialect = JdbcDialectLoader.load(config.getJdbcConnectionConfig().getUrl(), config.getJdbcConnectionConfig().getDialect(), config.getJdbcConnectionConfig().getCompatibleMode(), config.getJdbcConnectionConfig());
        jdbcDialect.connectionUrlParse(config.getJdbcConnectionConfig().getUrl(), config.getJdbcConnectionConfig().getProperties(), jdbcDialect.defaultParameter());
        return () -> new JdbcSource(config);
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{JdbcSourceOptions.URL, JdbcSourceOptions.DRIVER}).optional(new Option[]{JdbcSourceOptions.USERNAME, JdbcSourceOptions.PASSWORD, JdbcSourceOptions.CONNECTION_CHECK_TIMEOUT_SEC, JdbcSourceOptions.FETCH_SIZE, JdbcSourceOptions.PARTITION_COLUMN, JdbcSourceOptions.PARTITION_UPPER_BOUND, JdbcSourceOptions.PARTITION_LOWER_BOUND, JdbcSourceOptions.PARTITION_NUM, JdbcSourceOptions.COMPATIBLE_MODE, JdbcSourceOptions.STRING_SPLIT_MODE, JdbcSourceOptions.STRING_SPLIT_MODE_COLLATE, JdbcSourceOptions.PROPERTIES, JdbcSourceOptions.QUERY, JdbcSourceOptions.USE_SELECT_COUNT, JdbcSourceOptions.SKIP_ANALYZE, JdbcSourceOptions.USE_REGEX, JdbcSourceOptions.TABLE_PATH, JdbcSourceOptions.WHERE_CONDITION, JdbcSourceOptions.TABLE_LIST, JdbcSourceOptions.SPLIT_SIZE, JdbcSourceOptions.SPLIT_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND, JdbcSourceOptions.SPLIT_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND, JdbcSourceOptions.SPLIT_SAMPLE_SHARDING_THRESHOLD, JdbcSourceOptions.SPLIT_INVERSE_SAMPLING_RATE, JdbcSourceOptions.DECIMAL_TYPE_NARROWING, JdbcSourceOptions.INT_TYPE_NARROWING, JdbcSourceOptions.DIALECT}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return JdbcSource.class;
    }
}

