/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.db2;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class DB2TypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(DB2TypeConverter.class);
    public static final String DB2_BOOLEAN = "BOOLEAN";
    public static final String DB2_SMALLINT = "SMALLINT";
    public static final String DB2_INTEGER = "INTEGER";
    public static final String DB2_INT = "INT";
    public static final String DB2_BIGINT = "BIGINT";
    public static final String DB2_DECIMAL = "DECIMAL";
    public static final String DB2_DEC = "DEC";
    public static final String DB2_NUMERIC = "NUMERIC";
    public static final String DB2_NUM = "NUM";
    public static final String DB2_REAL = "REAL";
    public static final String DB2_DOUBLE = "DOUBLE";
    public static final String DB2_DECFLOAT = "DECFLOAT";
    public static final String DB2_CHARACTER = "CHARACTER";
    public static final String DB2_CHAR = "CHAR";
    public static final String DB2_CHAR_FOR_BIT_DATA = "CHAR FOR BIT DATA";
    public static final String DB2_VARCHAR = "VARCHAR";
    public static final String DB2_VARCHAR_FOR_BIT_DATA = "VARCHAR FOR BIT DATA";
    public static final String DB2_LONG_VARCHAR = "LONG VARCHAR";
    public static final String DB2_LONG_VARCHAR_FOR_BIT_DATA = "LONG VARCHAR FOR BIT DATA";
    public static final String DB2_CLOB = "CLOB";
    public static final String DB2_GRAPHIC = "GRAPHIC";
    public static final String DB2_VARGRAPHIC = "VARGRAPHIC";
    public static final String DB2_DBCLOB = "DBCLOB";
    public static final String DB2_BINARY = "BINARY";
    public static final String DB2_VARBINARY = "VARBINARY";
    public static final String DB2_DATE = "DATE";
    public static final String DB2_TIME = "TIME";
    public static final String DB2_TIMESTAMP = "TIMESTAMP";
    public static final String DB2_BLOB = "BLOB";
    public static final String DB2_XML = "XML";
    public static final int MAX_TIMESTAMP_SCALE = 12;
    public static final long MAX_CHAR_LENGTH = 255L;
    public static final long MAX_VARCHAR_LENGTH = 32672L;
    public static final long MAX_CLOB_LENGTH = Integer.MAX_VALUE;
    public static final long MAX_BINARY_LENGTH = 255L;
    public static final long MAX_VARBINARY_LENGTH = 32672L;
    public static final long MAX_BLOB_LENGTH = Integer.MAX_VALUE;
    public static final long MAX_PRECISION = 31L;
    public static final long DEFAULT_PRECISION = 5L;
    public static final int MAX_SCALE = 30;
    public static final int DEFAULT_SCALE = 0;
    public static final DB2TypeConverter INSTANCE = new DB2TypeConverter();

    public String identifier() {
        return "DB2";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        String db2Type;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (db2Type = typeDefine.getDataType().toUpperCase()) {
            case "BOOLEAN": {
                builder.sourceType(DB2_BOOLEAN);
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "SMALLINT": {
                builder.sourceType(DB2_SMALLINT);
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INT": 
            case "INTEGER": {
                builder.sourceType(DB2_INT);
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": {
                builder.sourceType(DB2_BIGINT);
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "REAL": {
                builder.sourceType(DB2_REAL);
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE": {
                builder.sourceType(DB2_DOUBLE);
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "DECFLOAT": {
                builder.sourceType(DB2_DECFLOAT);
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "DECIMAL": {
                builder.sourceType(String.format("%s(%s,%s)", DB2_DECIMAL, typeDefine.getPrecision(), typeDefine.getScale()));
                builder.dataType((SeaTunnelDataType)new DecimalType(Math.toIntExact(typeDefine.getPrecision()), typeDefine.getScale().intValue()));
                builder.columnLength(typeDefine.getPrecision());
                builder.scale(typeDefine.getScale());
                break;
            }
            case "CHARACTER": 
            case "CHAR": {
                builder.sourceType(String.format("%s(%d)", DB2_CHAR, typeDefine.getLength()));
                builder.columnLength(typeDefine.getLength());
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "VARCHAR": {
                builder.sourceType(String.format("%s(%d)", DB2_VARCHAR, typeDefine.getLength()));
                builder.columnLength(typeDefine.getLength());
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "LONG VARCHAR": {
                builder.sourceType(DB2_LONG_VARCHAR);
                builder.columnLength(typeDefine.getLength());
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "CLOB": {
                builder.sourceType(String.format("%s(%d)", DB2_CLOB, typeDefine.getLength()));
                builder.columnLength(typeDefine.getLength());
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "GRAPHIC": {
                builder.sourceType(String.format("%s(%d)", DB2_GRAPHIC, typeDefine.getLength()));
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "VARGRAPHIC": {
                builder.sourceType(String.format("%s(%d)", DB2_VARGRAPHIC, typeDefine.getLength()));
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "DBCLOB": {
                builder.sourceType(String.format("%s(%d)", DB2_DBCLOB, typeDefine.getLength()));
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "XML": {
                builder.sourceType(DB2_XML);
                builder.columnLength(Long.valueOf(Integer.MAX_VALUE));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "BINARY": {
                builder.sourceType(String.format("%s(%d)", DB2_BINARY, typeDefine.getLength()));
                builder.columnLength(typeDefine.getLength());
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case "VARBINARY": {
                builder.sourceType(String.format("%s(%d)", DB2_VARBINARY, typeDefine.getLength()));
                builder.columnLength(typeDefine.getLength());
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case "BLOB": {
                builder.sourceType(String.format("%s(%d)", DB2_BLOB, typeDefine.getLength()));
                builder.columnLength(typeDefine.getLength());
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case "DATE": {
                builder.sourceType(DB2_DATE);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": {
                builder.sourceType(DB2_TIME);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                break;
            }
            case "TIMESTAMP": {
                builder.sourceType(String.format("%s(%d)", DB2_TIMESTAMP, typeDefine.getScale()));
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"DB2", (String)db2Type, (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(DB2_BOOLEAN);
                builder.dataType(DB2_BOOLEAN);
                break;
            }
            case TINYINT: 
            case SMALLINT: {
                builder.columnType(DB2_SMALLINT);
                builder.dataType(DB2_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(DB2_INT);
                builder.dataType(DB2_INT);
                break;
            }
            case BIGINT: {
                builder.columnType(DB2_BIGINT);
                builder.dataType(DB2_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(DB2_REAL);
                builder.dataType(DB2_REAL);
                break;
            }
            case DOUBLE: {
                builder.columnType(DB2_DOUBLE);
                builder.dataType(DB2_DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 5L;
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 31L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 31L));
                    precision = 31L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 31L, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 30) {
                    scale = 30;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 30, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", DB2_DECIMAL, precision, scale));
                builder.dataType(DB2_DECIMAL);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case BYTES: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(String.format("%s(%s)", DB2_VARBINARY, 32672L));
                    builder.dataType(DB2_VARBINARY);
                    builder.length(column.getColumnLength());
                    break;
                }
                if (column.getColumnLength() <= 255L) {
                    builder.columnType(String.format("%s(%s)", DB2_BINARY, column.getColumnLength()));
                    builder.dataType(DB2_BINARY);
                    builder.length(column.getColumnLength());
                    break;
                }
                if (column.getColumnLength() <= 32672L) {
                    builder.columnType(String.format("%s(%s)", DB2_VARBINARY, column.getColumnLength()));
                    builder.dataType(DB2_VARBINARY);
                    builder.length(column.getColumnLength());
                    break;
                }
                long length = column.getColumnLength();
                if (length > Integer.MAX_VALUE) {
                    length = Integer.MAX_VALUE;
                    log.warn("The length of blob type {} is out of range, it will be converted to {}({})", new Object[]{column.getName(), DB2_BLOB, length});
                }
                builder.columnType(String.format("%s(%s)", DB2_BLOB, length));
                builder.dataType(DB2_BLOB);
                builder.length(Long.valueOf(length));
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(String.format("%s(%s)", DB2_VARCHAR, 32672L));
                    builder.dataType(DB2_VARCHAR);
                    builder.length(column.getColumnLength());
                    break;
                }
                if (column.getColumnLength() <= 255L) {
                    builder.columnType(String.format("%s(%s)", DB2_CHAR, column.getColumnLength()));
                    builder.dataType(DB2_CHAR);
                    builder.length(column.getColumnLength());
                    break;
                }
                if (column.getColumnLength() <= 32672L) {
                    builder.columnType(String.format("%s(%s)", DB2_VARCHAR, column.getColumnLength()));
                    builder.dataType(DB2_VARCHAR);
                    builder.length(column.getColumnLength());
                    break;
                }
                long length = column.getColumnLength();
                if (length > Integer.MAX_VALUE) {
                    length = Integer.MAX_VALUE;
                    log.warn("The length of clob type {} is out of range, it will be converted to {}({})", new Object[]{column.getName(), DB2_CLOB, length});
                }
                builder.columnType(String.format("%s(%s)", DB2_CLOB, length));
                builder.dataType(DB2_CLOB);
                builder.length(Long.valueOf(length));
                break;
            }
            case DATE: {
                builder.columnType(DB2_DATE);
                builder.dataType(DB2_DATE);
                break;
            }
            case TIME: {
                builder.columnType(DB2_TIME);
                builder.dataType(DB2_TIME);
                break;
            }
            case TIMESTAMP: {
                if (column.getScale() != null && column.getScale() > 0) {
                    int timestampScale = column.getScale();
                    if (column.getScale() > 12) {
                        timestampScale = 12;
                        log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 12, timestampScale});
                    }
                    builder.columnType(String.format("%s(%s)", DB2_TIMESTAMP, timestampScale));
                    builder.scale(Integer.valueOf(timestampScale));
                } else {
                    builder.columnType(DB2_TIMESTAMP);
                }
                builder.dataType(DB2_TIMESTAMP);
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"DB2", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

