/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.saphana;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.saphana.SapHanaTypeConverter;

public class SapHanaCreateTableSqlBuilder
extends AbstractJdbcCreateTableSqlBuilder {
    private final List<Column> columns;
    private final PrimaryKey primaryKey;
    private final String sourceCatalogName;
    private final String fieldIde;
    private final String comment;
    private final List<ConstraintKey> constraintKeys;
    public List<String> createIndexSqls = new ArrayList<String>();
    private boolean createIndex;

    public SapHanaCreateTableSqlBuilder(CatalogTable catalogTable, boolean createIndex) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.sourceCatalogName = catalogTable.getCatalogName();
        this.fieldIde = (String)catalogTable.getOptions().get("fieldIde");
        this.comment = catalogTable.getComment();
        this.constraintKeys = catalogTable.getTableSchema().getConstraintKeys();
        this.createIndex = createIndex;
    }

    public String build(TablePath tablePath) {
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append("CREATE TABLE ").append(CatalogUtils.quoteIdentifier(tablePath.getDatabaseName(), this.fieldIde, "\"")).append(".").append(CatalogUtils.quoteIdentifier(tablePath.getTableName(), this.fieldIde, "\"")).append(" (\n");
        List columnSqls = this.columns.stream().map(column -> CatalogUtils.getFieldIde(this.buildColumnSql((Column)column), this.fieldIde)).collect(Collectors.toList());
        if (this.createIndex && this.primaryKey != null && this.primaryKey.getColumnNames() != null && !this.primaryKey.getColumnNames().isEmpty()) {
            columnSqls.add(this.buildPrimaryKeySql(this.primaryKey));
        }
        if (this.createIndex && CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                if (StringUtils.isBlank((CharSequence)constraintKey.getConstraintName()) || this.primaryKey != null && (StringUtils.equals((CharSequence)this.primaryKey.getPrimaryKey(), (CharSequence)constraintKey.getConstraintName()) || this.primaryContainsAllConstrainKey(this.primaryKey, constraintKey))) continue;
                switch (constraintKey.getConstraintType()) {
                    case UNIQUE_KEY: {
                        String uniqueKeySql = this.buildUniqueKeySql(constraintKey);
                        columnSqls.add(uniqueKeySql);
                        break;
                    }
                }
            }
        }
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n)");
        if (this.comment != null) {
            createTableSql.append(" COMMENT '").append(this.comment).append("'");
        }
        return createTableSql.toString();
    }

    String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append("\"").append(column.getName()).append("\" ");
        String columnType = column.getSinkType() != null ? column.getSinkType() : (StringUtils.equalsIgnoreCase((CharSequence)"SapHana", (CharSequence)this.sourceCatalogName) && StringUtils.isNotBlank((CharSequence)column.getSourceType()) ? column.getSourceType() : SapHanaTypeConverter.INSTANCE.reconvert(column).getColumnType());
        columnSql.append(columnType);
        if (column.isNullable()) {
            columnSql.append(" NULL");
        } else {
            columnSql.append(" NOT NULL");
        }
        if (column.getComment() != null) {
            columnSql.append(" COMMENT '").append(column.getComment()).append("'");
        }
        return columnSql.toString();
    }

    private String buildPrimaryKeySql(PrimaryKey primaryKey) {
        String key = primaryKey.getColumnNames().stream().map(columnName -> "\"" + columnName + "\"").collect(Collectors.joining(", "));
        return String.format("PRIMARY KEY (%s)", CatalogUtils.quoteIdentifier(key, this.fieldIde));
    }

    private String buildUniqueKeySql(ConstraintKey constraintKey) {
        String key = constraintKey.getColumnNames().stream().map(columnName -> "\"" + columnName.getColumnName() + "\"").collect(Collectors.joining(", "));
        return String.format("UNIQUE (%s)", CatalogUtils.quoteIdentifier(key, this.fieldIde));
    }

    public List<String> getCreateIndexSqls() {
        return this.createIndexSqls;
    }
}

