/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase;

import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeConverter;

public class OceanBaseOracleCreateTableSqlBuilder
extends OracleCreateTableSqlBuilder {
    public OceanBaseOracleCreateTableSqlBuilder(CatalogTable catalogTable, boolean createIndex) {
        super(catalogTable, createIndex);
    }

    @Override
    protected String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append("\"").append(column.getName()).append("\" ");
        String columnType = null;
        if (column.getSinkType() != null) {
            columnType = column.getSinkType();
        } else if (StringUtils.isNotBlank((CharSequence)column.getSourceType())) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"OceanBase", (CharSequence)this.sourceCatalogName)) {
                columnType = column.getSourceType();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"Oracle", (CharSequence)this.sourceCatalogName)) {
                switch (column.getSourceType().toUpperCase()) {
                    case "LONG": {
                        columnType = "CLOB";
                        break;
                    }
                    case "LONG RAW": 
                    case "BFILE": {
                        columnType = "BLOB";
                        break;
                    }
                    case "NCLOB": {
                        columnType = "NVARCHAR2(32767)";
                        break;
                    }
                    case "REAL": {
                        columnType = "FLOAT";
                        break;
                    }
                    default: {
                        columnType = column.getSourceType();
                    }
                }
            }
        }
        if (columnType == null) {
            columnType = OracleTypeConverter.INSTANCE.reconvert(column).getColumnType();
        }
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        return columnSql.toString();
    }
}

