/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.service.failsafe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.service.failsafe.CircuitBreakerMetrics;
import org.tikv.service.failsafe.HealthCounts;
import org.tikv.service.failsafe.MetricsListener;

public class CircuitBreakerMetricsImpl
implements CircuitBreakerMetrics {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerMetricsImpl.class);
    private final int windowInMS;
    private final List<MetricsListener> listeners;
    private final AtomicReference<SingleWindowMetrics> currentMetrics;
    private final ScheduledExecutorService scheduler;
    private static final int SCHEDULER_INITIAL_DELAY = 1000;
    private static final int SCHEDULER_PERIOD = 1000;

    public CircuitBreakerMetricsImpl(int windowInSeconds) {
        this.windowInMS = windowInSeconds * 1000;
        this.listeners = new ArrayList<MetricsListener>();
        this.currentMetrics = new AtomicReference<SingleWindowMetrics>(new SingleWindowMetrics());
        this.scheduler = new ScheduledThreadPoolExecutor(1, new BasicThreadFactory.Builder().namingPattern("circuit-breaker-metrics-%d").daemon(true).build());
        this.scheduler.scheduleAtFixedRate(this::onReachCircuitWindow, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void recordSuccess() {
        this.currentMetrics.get().recordSuccess();
    }

    @Override
    public void recordFailure() {
        this.currentMetrics.get().recordFailure();
    }

    private void onReachCircuitWindow() {
        SingleWindowMetrics singleWindowMetrics = this.currentMetrics.get();
        if (System.currentTimeMillis() < singleWindowMetrics.getStartMS() + (long)this.windowInMS) {
            return;
        }
        if (!this.currentMetrics.compareAndSet(singleWindowMetrics, new SingleWindowMetrics())) {
            return;
        }
        logger.debug("window timeout, reset SingleWindowMetrics");
        HealthCounts healthCounts = singleWindowMetrics.getHealthCounts();
        for (MetricsListener metricsListener : this.listeners) {
            metricsListener.onNext(healthCounts);
        }
    }

    @Override
    public void addListener(MetricsListener metricsListener) {
        this.listeners.add(metricsListener);
    }

    @Override
    public void close() throws IOException {
        this.scheduler.shutdown();
    }

    static class SingleWindowMetrics {
        private final long startMS = System.currentTimeMillis();
        private final AtomicLong totalCount = new AtomicLong(0L);
        private final AtomicLong errorCount = new AtomicLong(0L);

        SingleWindowMetrics() {
        }

        public void recordSuccess() {
            this.totalCount.incrementAndGet();
        }

        public void recordFailure() {
            this.totalCount.incrementAndGet();
            this.errorCount.incrementAndGet();
        }

        public HealthCounts getHealthCounts() {
            return new HealthCounts(this.totalCount.get(), this.errorCount.get());
        }

        public long getStartMS() {
            return this.startMS;
        }
    }
}

