/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.PDClient;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.kvproto.Metapb;

public class StoreVersion {
    private static final int SCALE = 10000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int v0 = 9999;
    private int v1 = 9999;
    private int v2 = 9999;

    private StoreVersion(String version) {
        try {
            String[] parts;
            if (version.startsWith("v")) {
                version = version.substring(1);
            }
            if ((parts = version.split("[.-]")).length > 0) {
                this.v0 = Integer.parseInt(parts[0]);
            }
            if (parts.length > 1) {
                this.v1 = Integer.parseInt(parts[1]);
            }
            if (parts.length > 2) {
                this.v2 = Integer.parseInt(parts[2]);
            }
        }
        catch (Exception e) {
            this.logger.warn("invalid store version: " + version, (Throwable)e);
        }
    }

    public static int compareTo(String v0, String v1) {
        return new StoreVersion(v0).toIntVersion() - new StoreVersion(v1).toIntVersion();
    }

    public static boolean minTiKVVersion(String version, PDClient pdClient) {
        StoreVersion storeVersion = new StoreVersion(version);
        ConcreteBackOffer bo = ConcreteBackOffer.newCustomBackOff(5000);
        List storeList = pdClient.getAllStores(bo).stream().filter(store -> !StoreVersion.isTiFlash(store) && (store.getState() == Metapb.StoreState.Up || store.getState() == Metapb.StoreState.Offline)).collect(Collectors.toList());
        for (Metapb.Store store2 : storeList) {
            if (!storeVersion.greatThan(new StoreVersion(store2.getVersion()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isTiFlash(Metapb.Store store) {
        for (Metapb.StoreLabel label : store.getLabelsList()) {
            if (!label.getKey().equals(TiStoreType.TiFlash.getLabelKey()) || !label.getValue().equals(TiStoreType.TiFlash.getLabelValue())) continue;
            return true;
        }
        return false;
    }

    private int toIntVersion() {
        return this.v0 * 10000 * 10000 + this.v1 * 10000 + this.v2;
    }

    private boolean greatThan(StoreVersion other) {
        return this.toIntVersion() > other.toIntVersion();
    }
}

