/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.snowflake;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class SnowflakeTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeTypeConverter.class);
    private static final String SNOWFLAKE_NUMBER = "NUMBER";
    private static final String SNOWFLAKE_DECIMAL = "DECIMAL";
    private static final String SNOWFLAKE_NUMERIC = "NUMERIC";
    private static final String SNOWFLAKE_INT = "INT";
    private static final String SNOWFLAKE_INTEGER = "INTEGER";
    private static final String SNOWFLAKE_BIGINT = "BIGINT";
    private static final String SNOWFLAKE_SMALLINT = "SMALLINT";
    private static final String SNOWFLAKE_TINYINT = "TINYINT";
    private static final String SNOWFLAKE_BYTEINT = "BYTEINT";
    private static final String SNOWFLAKE_FLOAT = "FLOAT";
    private static final String SNOWFLAKE_FLOAT4 = "FLOAT4";
    private static final String SNOWFLAKE_FLOAT8 = "FLOAT8";
    private static final String SNOWFLAKE_DOUBLE = "DOUBLE";
    private static final String SNOWFLAKE_DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String SNOWFLAKE_REAL = "REAL";
    private static final String SNOWFLAKE_VARCHAR = "VARCHAR";
    private static final String SNOWFLAKE_CHAR = "CHAR";
    private static final String SNOWFLAKE_CHARACTER = "CHARACTER";
    private static final String SNOWFLAKE_STRING = "STRING";
    private static final String SNOWFLAKE_TEXT = "TEXT";
    private static final String SNOWFLAKE_BINARY = "BINARY";
    private static final String SNOWFLAKE_VARBINARY = "VARBINARY";
    private static final String SNOWFLAKE_BOOLEAN = "BOOLEAN";
    private static final String SNOWFLAKE_DATE = "DATE";
    private static final String SNOWFLAKE_DATE_TIME = "DATE_TIME";
    private static final String SNOWFLAKE_TIME = "TIME";
    private static final String SNOWFLAKE_TIMESTAMP = "TIMESTAMP";
    private static final String SNOWFLAKE_TIMESTAMP_LTZ = "TIMESTAMPLTZ";
    private static final String SNOWFLAKE_TIMESTAMP_NTZ = "TIMESTAMPNTZ";
    private static final String SNOWFLAKE_TIMESTAMP_TZ = "TIMESTAMPTZ";
    private static final String SNOWFLAKE_GEOGRAPHY = "GEOGRAPHY";
    private static final String SNOWFLAKE_GEOMETRY = "GEOMETRY";
    private static final String SNOWFLAKE_VARIANT = "VARIANT";
    private static final String SNOWFLAKE_OBJECT = "OBJECT";
    public static final SnowflakeTypeConverter INSTANCE = new SnowflakeTypeConverter();
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 37;
    public static final int DEFAULT_PRECISION = 10;
    public static final int DEFAULT_SCALE = 0;

    public String identifier() {
        return "Snowflake";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        String dataType;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (dataType = typeDefine.getDataType().toUpperCase()) {
            case "SMALLINT": 
            case "TINYINT": 
            case "BYTEINT": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INTEGER": 
            case "INT": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "DECIMAL": 
            case "NUMERIC": 
            case "NUMBER": {
                builder.dataType((SeaTunnelDataType)new DecimalType(Math.toIntExact(typeDefine.getPrecision() == null ? 10L : typeDefine.getPrecision()), typeDefine.getScale() == null ? 0 : typeDefine.getScale()));
                break;
            }
            case "REAL": 
            case "FLOAT4": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE": 
            case "DOUBLE PRECISION": 
            case "FLOAT8": 
            case "FLOAT": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "BOOLEAN": {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "CHAR": 
            case "CHARACTER": 
            case "VARCHAR": 
            case "STRING": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "TEXT": 
            case "VARIANT": 
            case "OBJECT": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "GEOGRAPHY": 
            case "GEOMETRY": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "BINARY": 
            case "VARBINARY": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case "DATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(Integer.valueOf(9));
                break;
            }
            case "DATE_TIME": 
            case "TIMESTAMP": 
            case "TIMESTAMPLTZ": 
            case "TIMESTAMPNTZ": 
            case "TIMESTAMPTZ": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(Integer.valueOf(9));
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"Snowflake", (String)dataType, (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case TINYINT: 
            case SMALLINT: {
                builder.columnType(SNOWFLAKE_SMALLINT);
                builder.dataType(SNOWFLAKE_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(SNOWFLAKE_INTEGER);
                builder.dataType(SNOWFLAKE_INTEGER);
                break;
            }
            case BIGINT: {
                builder.columnType(SNOWFLAKE_BIGINT);
                builder.dataType(SNOWFLAKE_BIGINT);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 10L;
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 38L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 38L));
                    precision = 38L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 38, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 37) {
                    scale = 37;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 37, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", SNOWFLAKE_DECIMAL, precision, scale));
                builder.dataType(SNOWFLAKE_DECIMAL);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case FLOAT: {
                builder.columnType(SNOWFLAKE_FLOAT4);
                builder.dataType(SNOWFLAKE_FLOAT4);
                break;
            }
            case DOUBLE: {
                builder.columnType(SNOWFLAKE_DOUBLE_PRECISION);
                builder.dataType(SNOWFLAKE_DOUBLE_PRECISION);
                break;
            }
            case BOOLEAN: {
                builder.columnType(SNOWFLAKE_BOOLEAN);
                builder.dataType(SNOWFLAKE_BOOLEAN);
                break;
            }
            case STRING: {
                if (column.getColumnLength() != null) {
                    if (column.getColumnLength() > 0x1000000L) {
                        builder.columnType(SNOWFLAKE_BINARY);
                        builder.dataType(SNOWFLAKE_BINARY);
                    } else if (column.getColumnLength() > 0L) {
                        builder.columnType(String.format("%s(%s)", SNOWFLAKE_VARCHAR, column.getColumnLength()));
                        builder.dataType(SNOWFLAKE_VARCHAR);
                    } else {
                        builder.columnType(SNOWFLAKE_STRING);
                        builder.dataType(SNOWFLAKE_STRING);
                    }
                } else {
                    builder.columnType(SNOWFLAKE_STRING);
                    builder.dataType(SNOWFLAKE_STRING);
                }
                builder.length(column.getColumnLength());
                break;
            }
            case DATE: {
                builder.columnType(SNOWFLAKE_DATE);
                builder.dataType(SNOWFLAKE_DATE);
                break;
            }
            case BYTES: {
                builder.columnType(SNOWFLAKE_GEOMETRY);
                builder.dataType(SNOWFLAKE_GEOMETRY);
                break;
            }
            case TIME: {
                if (column.getScale() > 9) {
                    log.warn("The timestamp column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 9, 9});
                }
                builder.columnType(SNOWFLAKE_TIME);
                builder.dataType(SNOWFLAKE_TIME);
                break;
            }
            case TIMESTAMP: {
                if (column.getScale() > 9) {
                    log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 9, 9});
                }
                builder.columnType(SNOWFLAKE_TIMESTAMP);
                builder.dataType(SNOWFLAKE_TIMESTAMP);
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"Snowflake", (String)column.getDataType().getSqlType().toString(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

