/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle;

import com.google.auto.service.AutoService;
import javax.annotation.Nonnull;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectFactory;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleDialect;

@AutoService(value={JdbcDialectFactory.class})
public class OracleDialectFactory
implements JdbcDialectFactory {
    @Override
    public String dialectFactoryName() {
        return "Oracle";
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:oracle:thin:");
    }

    @Override
    public JdbcDialect create() {
        return new OracleDialect();
    }

    @Override
    public JdbcDialect create(@Nonnull String compatibleMode, String fieldIde) {
        return this.create(compatibleMode, fieldIde, null);
    }

    @Override
    public JdbcDialect create(@Nonnull String compatibleMode, String fieldIde, JdbcConnectionConfig jdbcConnectionConfig) {
        boolean handleBlobAsString = jdbcConnectionConfig != null && jdbcConnectionConfig.isHandleBlobAsString();
        return new OracleDialect(fieldIde, handleBlobAsString);
    }
}

