/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.db2;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.db2.DB2JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.db2.DB2TypeMapper;

public class DB2Dialect
implements JdbcDialect {
    @Override
    public String dialectName() {
        return "DB2";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new DB2JdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new DB2TypeMapper();
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String fieldList = String.join((CharSequence)", ", fieldNames);
        String placeholderList = Arrays.stream(fieldNames).map(field -> "?").collect(Collectors.joining(", "));
        String onClause = Arrays.stream(uniqueKeyFields).map(field -> "target." + field + " = source." + field).collect(Collectors.joining(" AND "));
        String whenMatchedClause = Arrays.stream(fieldNames).map(field -> "target." + field + " <> source." + field).collect(Collectors.joining(" OR "));
        String updateSetClause = Arrays.stream(fieldNames).map(field -> "target." + field + " = source." + field).collect(Collectors.joining(", "));
        String insertClause = "INSERT (" + fieldList + ") VALUES (" + Arrays.stream(fieldNames).map(field -> "source." + field).collect(Collectors.joining(", ")) + ")";
        String mergeStatement = String.format("MERGE INTO %s.%s AS target USING (VALUES (%s)) AS source (%s) ON %s WHEN MATCHED AND (%s) THEN UPDATE SET %s WHEN NOT MATCHED THEN %s;", database, tableName, placeholderList, fieldList, onClause, whenMatchedClause, updateSetClause, insertClause);
        return Optional.of(mergeStatement);
    }

    @Override
    public String dualTable() {
        return " FROM SYSIBM.SYSDUMMY1 ";
    }
}

