/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleURLParser;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;

@AutoService(value={Factory.class})
public class OracleCatalogFactory
implements CatalogFactory {
    public String factoryIdentifier() {
        return "Oracle";
    }

    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        String urlWithDatabase = (String)options.get(JdbcCatalogOptions.BASE_URL);
        JdbcUrlUtil.UrlInfo urlInfo = OracleURLParser.parse(urlWithDatabase);
        Optional defaultDatabase = urlInfo.getDefaultDatabase();
        if (!defaultDatabase.isPresent()) {
            throw new OptionValidationException(JdbcCatalogOptions.BASE_URL);
        }
        return new OracleCatalog(catalogName, (String)options.get(JdbcCatalogOptions.USERNAME), (String)options.get(JdbcCatalogOptions.PASSWORD), urlInfo, (String)options.get(JdbcCatalogOptions.SCHEMA), (Boolean)options.get(JdbcOptions.DECIMAL_TYPE_NARROWING), (String)options.get(JdbcOptions.DRIVER), options.getOptional(JdbcOptions.HANDLE_BLOB_AS_STRING).orElse(false));
    }

    public OptionRule optionRule() {
        return JdbcCatalogOptions.BASE_RULE.build();
    }
}

