/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.file.FileStreamSourceTask;
import org.apache.kafka.connect.source.SourceConnector;

public class FileStreamSourceConnector
extends SourceConnector {
    public static final String TOPIC_CONFIG = "topic";
    public static final String FILE_CONFIG = "file";
    public static final String TASK_BATCH_SIZE_CONFIG = "batch.size";
    public static final int DEFAULT_TASK_BATCH_SIZE = 2000;
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("file", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Source filename. If not specified, the standard input will be used").define("topic", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "The topic to publish data to").define("batch.size", ConfigDef.Type.INT, 2000, ConfigDef.Importance.LOW, "The maximum number of records the Source task can read from file one time");
    private String filename;
    private String topic;
    private int batchSize;

    @Override
    public String version() {
        return AppInfoParser.getVersion();
    }

    @Override
    public void start(Map<String, String> props) {
        AbstractConfig parsedConfig = new AbstractConfig(CONFIG_DEF, props);
        this.filename = parsedConfig.getString(FILE_CONFIG);
        List<String> topics = parsedConfig.getList(TOPIC_CONFIG);
        if (topics.size() != 1) {
            throw new ConfigException("'topic' in FileStreamSourceConnector configuration requires definition of a single topic");
        }
        this.topic = topics.get(0);
        this.batchSize = parsedConfig.getInt(TASK_BATCH_SIZE_CONFIG);
    }

    @Override
    public Class<? extends Task> taskClass() {
        return FileStreamSourceTask.class;
    }

    @Override
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        HashMap<String, String> config = new HashMap<String, String>();
        if (this.filename != null) {
            config.put(FILE_CONFIG, this.filename);
        }
        config.put(TOPIC_CONFIG, this.topic);
        config.put(TASK_BATCH_SIZE_CONFIG, String.valueOf(this.batchSize));
        configs.add(config);
        return configs;
    }

    @Override
    public void stop() {
    }

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }
}

