/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.SQLUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.DefaultValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JdbcDialect
extends Serializable {
    public static final Logger log = LoggerFactory.getLogger((String)JdbcDialect.class.getName());

    public String dialectName();

    public JdbcRowConverter getRowConverter();

    default public TypeConverter<BasicTypeDefine> getTypeConverter() {
        throw new UnsupportedOperationException("TypeConverter is not supported");
    }

    public JdbcDialectTypeMapper getJdbcDialectTypeMapper();

    default public String hashModForField(String nativeType, String fieldName, int mod) {
        return this.hashModForField(fieldName, mod);
    }

    default public String hashModForField(String fieldName, int mod) {
        return "ABS(MD5(" + this.quoteIdentifier(fieldName) + ") % " + mod + ")";
    }

    default public String quoteIdentifier(String identifier) {
        return identifier;
    }

    default public String quoteDatabaseIdentifier(String identifier) {
        return identifier;
    }

    default public String tableIdentifier(String database, String tableName) {
        return this.quoteDatabaseIdentifier(database) + "." + this.quoteIdentifier(tableName);
    }

    default public String getInsertIntoStatement(String database, String tableName, String[] fieldNames) {
        String columns = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName).collect(Collectors.joining(", "));
        return String.format("INSERT INTO %s (%s) VALUES (%s)", this.tableIdentifier(database, tableName), columns, placeholders);
    }

    default public String getUpdateStatement(String database, String tableName, String[] fieldNames, String[] conditionFields, boolean isPrimaryKeyUpdated) {
        fieldNames = (String[])Arrays.stream(fieldNames).filter(fieldName -> isPrimaryKeyUpdated || !Arrays.asList(conditionFields).contains(fieldName)).toArray(String[]::new);
        String setClause = Arrays.stream(fieldNames).map(fieldName -> String.format("%s = :%s", this.quoteIdentifier((String)fieldName), fieldName)).collect(Collectors.joining(", "));
        String conditionClause = Arrays.stream(conditionFields).map(fieldName -> String.format("%s = :%s", this.quoteIdentifier((String)fieldName), fieldName)).collect(Collectors.joining(" AND "));
        return String.format("UPDATE %s SET %s WHERE %s", this.tableIdentifier(database, tableName), setClause, conditionClause);
    }

    default public String getDeleteStatement(String database, String tableName, String[] conditionFields) {
        String conditionClause = Arrays.stream(conditionFields).map(fieldName -> String.format("%s = :%s", this.quoteIdentifier((String)fieldName), fieldName)).collect(Collectors.joining(" AND "));
        return String.format("DELETE FROM %s WHERE %s", this.tableIdentifier(database, tableName), conditionClause);
    }

    default public String getRowExistsStatement(String database, String tableName, String[] conditionFields) {
        String fieldExpressions = Arrays.stream(conditionFields).map(field -> String.format("%s = :%s", this.quoteIdentifier((String)field), field)).collect(Collectors.joining(" AND "));
        return String.format("SELECT 1 FROM %s WHERE %s", this.tableIdentifier(database, tableName), fieldExpressions);
    }

    public Optional<String> getUpsertStatement(String var1, String var2, String[] var3, String[] var4);

    default public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize == Integer.MIN_VALUE || fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        }
        return statement;
    }

    default public ResultSetMetaData getResultSetMetaData(Connection conn, String query) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(query);
        return ps.getMetaData();
    }

    default public String extractTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    default public String getFieldIde(String identifier, String fieldIde) {
        if (StringUtils.isEmpty(fieldIde)) {
            return identifier;
        }
        switch (FieldIdeEnum.valueOf(fieldIde.toUpperCase())) {
            case LOWERCASE: {
                return identifier.toLowerCase();
            }
            case UPPERCASE: {
                return identifier.toUpperCase();
            }
        }
        return identifier;
    }

    default public Map<String, String> defaultParameter() {
        return new HashMap<String, String>();
    }

    default public void connectionUrlParse(String url, Map<String, String> info, Map<String, String> defaultParameter) {
        defaultParameter.forEach((key, value) -> {
            if (!url.contains((CharSequence)key) && !info.containsKey(key)) {
                info.put((String)key, (String)value);
            }
        });
    }

    default public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath);
    }

    default public String tableIdentifier(TablePath tablePath) {
        return tablePath.getFullName();
    }

    default public Long approximateRowCntStatement(Connection connection, JdbcSourceTable table) throws SQLException {
        if (StringUtils.isNotBlank(table.getQuery())) {
            return SQLUtils.countForSubquery(connection, table.getQuery());
        }
        return SQLUtils.countForTable(connection, this.tableIdentifier(table.getTablePath()));
    }

    default public Object[] sampleDataFromColumn(Connection connection, JdbcSourceTable table, String columnName, int samplingRate, int fetchSize) throws Exception {
        String sampleQuery = StringUtils.isNotBlank(table.getQuery()) ? String.format("SELECT %s FROM (%s) AS T", this.quoteIdentifier(columnName), table.getQuery()) : String.format("SELECT %s FROM %s", this.quoteIdentifier(columnName), this.tableIdentifier(table.getTablePath()));
        try (PreparedStatement stmt = this.creatPreparedStatement(connection, sampleQuery, fetchSize);){
            Object[] objectArray;
            block14: {
                log.info(String.format("Split Chunk, approximateRowCntStatement: %s", sampleQuery));
                ResultSet rs = stmt.executeQuery();
                try {
                    int count = 0;
                    ArrayList<Object> results = new ArrayList<Object>();
                    while (rs.next()) {
                        if (++count % samplingRate == 0) {
                            results.add(rs.getObject(1));
                        }
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException("Thread interrupted");
                    }
                    Object[] resultsArray = results.toArray();
                    Arrays.sort(resultsArray);
                    objectArray = resultsArray;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return objectArray;
        }
    }

    default public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = this.quoteIdentifier(columnName);
        String sqlQuery = StringUtils.isNotBlank(table.getQuery()) ? String.format("SELECT MAX(%s) FROM (SELECT %s FROM (%s) AS T1 WHERE %s >= ? ORDER BY %s ASC LIMIT %s) AS T2", quotedColumn, quotedColumn, table.getQuery(), quotedColumn, quotedColumn, chunkSize) : String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s >= ? ORDER BY %s ASC LIMIT %s) AS T", quotedColumn, quotedColumn, this.tableIdentifier(table.getTablePath()), quotedColumn, quotedColumn, chunkSize);
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            ps.setObject(1, includedLowerBound);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    Object object = rs.getObject(1);
                    return object;
                }
                throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
            }
        }
    }

    default public JdbcConnectionProvider getJdbcConnectionProvider(JdbcConnectionConfig jdbcConnectionConfig) {
        return new SimpleJdbcConnectionProvider(jdbcConnectionConfig);
    }

    default public String convertType(String columnName, String columnType) {
        return columnName;
    }

    default public void applySchemaChange(Connection connection, TablePath tablePath, SchemaChangeEvent event) throws SQLException {
        if (event instanceof AlterTableColumnsEvent) {
            for (AlterTableColumnEvent columnEvent : ((AlterTableColumnsEvent)event).getEvents()) {
                this.applySchemaChange(connection, tablePath, (SchemaChangeEvent)columnEvent);
            }
        } else if (event instanceof AlterTableChangeColumnEvent) {
            AlterTableChangeColumnEvent changeColumnEvent = (AlterTableChangeColumnEvent)event;
            if (!changeColumnEvent.getOldColumn().equals(changeColumnEvent.getColumn().getName()) && !this.columnExists(connection, tablePath, changeColumnEvent.getOldColumn()) && this.columnExists(connection, tablePath, changeColumnEvent.getColumn().getName())) {
                log.warn("Column {} already exists in table {}. Skipping change column operation. event: {}", new Object[]{changeColumnEvent.getColumn().getName(), tablePath.getFullName(), event});
                return;
            }
            this.applySchemaChange(connection, tablePath, changeColumnEvent);
        } else if (event instanceof AlterTableModifyColumnEvent) {
            this.applySchemaChange(connection, tablePath, (AlterTableModifyColumnEvent)event);
        } else if (event instanceof AlterTableAddColumnEvent) {
            AlterTableAddColumnEvent addColumnEvent = (AlterTableAddColumnEvent)event;
            if (this.columnExists(connection, tablePath, addColumnEvent.getColumn().getName())) {
                log.warn("Column {} already exists in table {}. Skipping add column operation. event: {}", new Object[]{addColumnEvent.getColumn().getName(), tablePath.getFullName(), event});
                return;
            }
            this.applySchemaChange(connection, tablePath, addColumnEvent);
        } else if (event instanceof AlterTableDropColumnEvent) {
            AlterTableDropColumnEvent dropColumnEvent = (AlterTableDropColumnEvent)event;
            if (!this.columnExists(connection, tablePath, dropColumnEvent.getColumn())) {
                log.warn("Column {} does not exist in table {}. Skipping drop column operation. event: {}", new Object[]{dropColumnEvent.getColumn(), tablePath.getFullName(), event});
                return;
            }
            this.applySchemaChange(connection, tablePath, dropColumnEvent);
        } else {
            throw new UnsupportedOperationException("Unsupported schemaChangeEvent: " + event);
        }
    }

    default public boolean columnExists(Connection connection, TablePath tablePath, String column) {
        boolean bl;
        block8: {
            String selectColumnSQL = String.format("SELECT %s FROM %s WHERE 1 != 1", this.quoteIdentifier(column), this.tableIdentifier(tablePath));
            Statement statement = connection.createStatement();
            try {
                bl = statement.execute(selectColumnSQL);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.debug("Column {} does not exist in table {}", new Object[]{column, tablePath.getFullName(), e});
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    default public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableAddColumnEvent event) throws SQLException {
        String sourceDialectName = event.getSourceDialectName();
        boolean sameCatalog = StringUtils.equals(this.dialectName(), sourceDialectName);
        BasicTypeDefine typeDefine = (BasicTypeDefine)this.getTypeConverter().reconvert(event.getColumn());
        String columnType = sameCatalog ? event.getColumn().getSourceType() : typeDefine.getColumnType();
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE").append(" ").append(this.tableIdentifier(tablePath)).append(" ").append("ADD COLUMN").append(" ").append(this.quoteIdentifier(event.getColumn().getName())).append(" ").append(columnType);
        if (event.getColumn().getDefaultValue() == null) {
            sqlBuilder.append(" ").append(event.getColumn().isNullable() ? "NULL" : "NOT NULL");
        } else {
            if (event.getColumn().isNullable()) {
                sqlBuilder.append(" NULL");
            } else if (sameCatalog) {
                sqlBuilder.append(" ").append(event.getColumn().isNullable() ? "NULL" : "NOT NULL");
            } else if (SqlType.TIMESTAMP.equals((Object)event.getColumn().getDataType().getSqlType())) {
                log.warn("Default value is not supported for column {} in table {}. Skipping add column operation. event: {}", new Object[]{event.getColumn().getName(), tablePath.getFullName(), event});
            } else {
                sqlBuilder.append(" NOT NULL");
            }
            if (sameCatalog) {
                sqlBuilder.append(" ").append(this.sqlClauseWithDefaultValue(typeDefine, sourceDialectName));
            }
        }
        if (event.getColumn().getComment() != null) {
            sqlBuilder.append(" ").append("COMMENT ").append("'").append(event.getColumn().getComment()).append("'");
        }
        if (event.getAfterColumn() != null) {
            sqlBuilder.append(" ").append("AFTER ").append(this.quoteIdentifier(event.getAfterColumn()));
        }
        String addColumnSQL = sqlBuilder.toString();
        try (Statement statement = connection.createStatement();){
            log.info("Executing add column SQL: {}", (Object)addColumnSQL);
            statement.execute(addColumnSQL);
        }
    }

    default public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableChangeColumnEvent event) throws SQLException {
        if (event.getColumn().getDataType() == null) {
            StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE").append(" ").append(this.tableIdentifier(tablePath)).append(" ").append("RENAME COLUMN").append(" ").append(this.quoteIdentifier(event.getOldColumn())).append(" TO ").append(this.quoteIdentifier(event.getColumn().getName()));
            try (Statement statement = connection.createStatement();){
                log.info("Executing rename column SQL: {}", (Object)sqlBuilder);
                statement.execute(sqlBuilder.toString());
            }
            return;
        }
        String sourceDialectName = event.getSourceDialectName();
        boolean sameCatalog = StringUtils.equals(this.dialectName(), sourceDialectName);
        BasicTypeDefine typeDefine = (BasicTypeDefine)this.getTypeConverter().reconvert(event.getColumn());
        String columnType = sameCatalog ? event.getColumn().getSourceType() : typeDefine.getColumnType();
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE").append(" ").append(this.tableIdentifier(tablePath)).append(" ").append("CHANGE COLUMN").append(" ").append(this.quoteIdentifier(event.getOldColumn())).append(" ").append(this.quoteIdentifier(event.getColumn().getName())).append(" ").append(columnType);
        if (event.getColumn().getDefaultValue() == null) {
            sqlBuilder.append(" ").append(event.getColumn().isNullable() ? "NULL" : "NOT NULL");
        } else {
            if (event.getColumn().isNullable()) {
                sqlBuilder.append(" NULL");
            } else if (sameCatalog) {
                sqlBuilder.append(" ").append(event.getColumn().isNullable() ? "NULL" : "NOT NULL");
            } else if (SqlType.TIMESTAMP.equals((Object)event.getColumn().getDataType().getSqlType())) {
                log.warn("Default value is not supported for column {} in table {}. Skipping add column operation. event: {}", new Object[]{event.getColumn().getName(), tablePath.getFullName(), event});
            } else {
                sqlBuilder.append(" NOT NULL");
            }
            if (sameCatalog) {
                sqlBuilder.append(" ").append(this.sqlClauseWithDefaultValue(typeDefine, sourceDialectName));
            }
        }
        if (event.getColumn().getComment() != null) {
            sqlBuilder.append(" ").append("COMMENT ").append("'").append(event.getColumn().getComment()).append("'");
        }
        if (event.getAfterColumn() != null) {
            sqlBuilder.append(" ").append("AFTER ").append(this.quoteIdentifier(event.getAfterColumn()));
        }
        String changeColumnSQL = sqlBuilder.toString();
        try (Statement statement = connection.createStatement();){
            log.info("Executing change column SQL: {}", (Object)changeColumnSQL);
            statement.execute(changeColumnSQL);
        }
    }

    default public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableModifyColumnEvent event) throws SQLException {
        String sourceDialectName = event.getSourceDialectName();
        boolean sameCatalog = StringUtils.equals(this.dialectName(), sourceDialectName);
        BasicTypeDefine typeDefine = (BasicTypeDefine)this.getTypeConverter().reconvert(event.getColumn());
        String columnType = sameCatalog ? event.getColumn().getSourceType() : typeDefine.getColumnType();
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE").append(" ").append(this.tableIdentifier(tablePath)).append(" ").append("MODIFY COLUMN").append(" ").append(this.quoteIdentifier(event.getColumn().getName())).append(" ").append(columnType);
        if (event.getColumn().getDefaultValue() == null) {
            sqlBuilder.append(" ").append(event.getColumn().isNullable() ? "NULL" : "NOT NULL");
        } else {
            if (event.getColumn().isNullable()) {
                sqlBuilder.append(" NULL");
            } else if (sameCatalog) {
                sqlBuilder.append(" ").append(event.getColumn().isNullable() ? "NULL" : "NOT NULL");
            } else if (SqlType.TIMESTAMP.equals((Object)event.getColumn().getDataType().getSqlType())) {
                log.warn("Default value is not supported for column {} in table {}. Skipping add column operation. event: {}", new Object[]{event.getColumn().getName(), tablePath.getFullName(), event});
            } else {
                sqlBuilder.append(" NOT NULL");
            }
            if (sameCatalog) {
                sqlBuilder.append(" ").append(this.sqlClauseWithDefaultValue(typeDefine, sourceDialectName));
            }
        }
        if (event.getColumn().getComment() != null) {
            sqlBuilder.append(" ").append("COMMENT ").append("'").append(event.getColumn().getComment()).append("'");
        }
        if (event.getAfterColumn() != null) {
            sqlBuilder.append(" ").append("AFTER ").append(this.quoteIdentifier(event.getAfterColumn()));
        }
        String modifyColumnSQL = sqlBuilder.toString();
        try (Statement statement = connection.createStatement();){
            log.info("Executing modify column SQL: {}", (Object)modifyColumnSQL);
            statement.execute(modifyColumnSQL);
        }
    }

    default public void applySchemaChange(Connection connection, TablePath tablePath, AlterTableDropColumnEvent event) throws SQLException {
        String dropColumnSQL = String.format("ALTER TABLE %s DROP COLUMN %s", this.tableIdentifier(tablePath), this.quoteIdentifier(event.getColumn()));
        try (Statement statement = connection.createStatement();){
            log.info("Executing drop column SQL: {}", (Object)dropColumnSQL);
            statement.execute(dropColumnSQL);
        }
    }

    default public String sqlClauseWithDefaultValue(BasicTypeDefine columnDefine, String sourceDialectName) {
        Object defaultValue = columnDefine.getDefaultValue();
        if (Objects.nonNull(defaultValue) && this.needsQuotesWithDefaultValue(columnDefine) && !this.isSpecialDefaultValue(defaultValue, sourceDialectName)) {
            defaultValue = this.quotesDefaultValue(defaultValue);
        }
        return "DEFAULT " + defaultValue;
    }

    default public boolean supportDefaultValue(BasicTypeDefine columnDefine) {
        return true;
    }

    default public boolean needsQuotesWithDefaultValue(BasicTypeDefine columnDefine) {
        return false;
    }

    default public boolean isSpecialDefaultValue(Object defaultValue, String sourceDialectName) {
        if ("MySQL".equals(sourceDialectName)) {
            return DefaultValueUtils.isMysqlSpecialDefaultValue(defaultValue);
        }
        return false;
    }

    default public String quotesDefaultValue(Object defaultValue) {
        return "'" + defaultValue + "'";
    }
}

