/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java6;

import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkHolder;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

final class SynchronizedMarkHolder
extends MarkHolder {
    private static final long GEN_MASK = 255L;
    private static final long START_N1S1_OP = Mark.Operation.TASK_START_N1S1.ordinal();
    private static final long START_N1S2_OP = Mark.Operation.TASK_START_N1S2.ordinal();
    private static final long STOP_N1S0_OP = Mark.Operation.TASK_END_N1S0.ordinal();
    private static final long STOP_N1S1_OP = Mark.Operation.TASK_END_N1S1.ordinal();
    private static final long STOP_N1S2_OP = Mark.Operation.TASK_END_N1S2.ordinal();
    private static final long EVENT_N1S1_OP = Mark.Operation.EVENT_N1S1.ordinal();
    private static final long EVENT_N1S2_OP = Mark.Operation.EVENT_N1S2.ordinal();
    private static final long EVENT_N2S2_OP = Mark.Operation.EVENT_N2S2.ordinal();
    private static final long LINK_OP = Mark.Operation.LINK.ordinal();
    private static final long TAG_N1S1_OP = Mark.Operation.TAG_N1S1.ordinal();
    private static final long TAG_KEYED_N0S2_OP = Mark.Operation.TAG_KEYED_N0S2.ordinal();
    private static final long TAG_KEYED_N1S1_OP = Mark.Operation.TAG_KEYED_N1S1.ordinal();
    private static final long TAG_KEYED_N2S1_OP = Mark.Operation.TAG_KEYED_N2S1.ordinal();
    private final int maxEvents;
    private final long maxEventsMask;
    private long nIdx;
    private long sIdx;
    private final long[] nums;
    private final String[] strings;

    SynchronizedMarkHolder() {
        this(32768);
    }

    SynchronizedMarkHolder(int maxEvents) {
        if ((maxEvents - 1 & maxEvents) != 0) {
            throw new IllegalArgumentException(maxEvents + " is not a power of two");
        }
        if (maxEvents <= 0) {
            throw new IllegalArgumentException(maxEvents + " is not positive");
        }
        this.maxEvents = maxEvents;
        this.maxEventsMask = (long)maxEvents - 1L;
        this.nums = new long[maxEvents];
        this.strings = new String[maxEvents];
    }

    private void writeNnss(long genOp, long n0, long n1, String s0, String s1) {
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n1;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s1;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    private void writeNss(long genOp, long n0, String s0, String s1) {
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s1;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    private void writeNs(long genOp, long n0, String s0) {
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    private void writeN(long genOp, long n0) {
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    private void writeNns(long genOp, long n0, long n1, String s0) {
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n1;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    private void writeSs(long genOp, String s0, String s1) {
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s1;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    @Override
    public synchronized void start(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        this.writeNs(gen + START_N1S1_OP, nanoTime, taskName);
        this.writeNs(gen + TAG_N1S1_OP, tagId, tagName);
    }

    @Override
    public synchronized void start(long gen, String taskName, long nanoTime) {
        this.writeNs(gen + START_N1S1_OP, nanoTime, taskName);
    }

    @Override
    public synchronized void start(long gen, String taskName, String subTaskName, long nanoTime) {
        this.writeNss(gen + START_N1S2_OP, nanoTime, taskName, subTaskName);
    }

    @Override
    public synchronized void link(long gen, long linkId) {
        this.writeN(gen + LINK_OP, linkId);
    }

    @Override
    public synchronized void stop(long gen, long nanoTime) {
        this.writeN(gen + STOP_N1S0_OP, nanoTime);
    }

    @Override
    public synchronized void stop(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        this.writeNs(gen + TAG_N1S1_OP, tagId, tagName);
        this.writeNs(gen + STOP_N1S1_OP, nanoTime, taskName);
    }

    @Override
    public synchronized void stop(long gen, String taskName, long nanoTime) {
        this.writeNs(gen + STOP_N1S1_OP, nanoTime, taskName);
    }

    @Override
    public synchronized void stop(long gen, String taskName, String subTaskName, long nanoTime) {
        this.writeNss(gen + STOP_N1S2_OP, nanoTime, taskName, subTaskName);
    }

    @Override
    public synchronized void event(long gen, String eventName, String tagName, long tagId, long nanoTime) {
        this.writeNnss(gen + EVENT_N2S2_OP, nanoTime, tagId, eventName, tagName);
    }

    @Override
    public synchronized void event(long gen, String eventName, long nanoTime) {
        this.writeNs(gen + EVENT_N1S1_OP, nanoTime, eventName);
    }

    @Override
    public synchronized void event(long gen, String eventName, String subEventName, long nanoTime) {
        this.writeNss(gen + EVENT_N1S2_OP, nanoTime, eventName, subEventName);
    }

    @Override
    public synchronized void attachTag(long gen, String tagName, long tagId) {
        this.writeNs(gen + TAG_N1S1_OP, tagId, tagName);
    }

    @Override
    public synchronized void attachKeyedTag(long gen, String name, long value0) {
        this.writeNs(gen + TAG_KEYED_N1S1_OP, value0, name);
    }

    @Override
    public synchronized void attachKeyedTag(long gen, String name, String value) {
        this.writeSs(gen + TAG_KEYED_N0S2_OP, name, value);
    }

    @Override
    public synchronized void attachKeyedTag(long gen, String name, long value0, long value1) {
        this.writeNns(gen + TAG_KEYED_N2S1_OP, value0, value1, name);
    }

    @Override
    public synchronized void resetForTest() {
        Arrays.fill(this.nums, 0L);
        Arrays.fill(this.strings, null);
        this.nIdx = 0L;
        this.sIdx = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Mark> read(boolean concurrentWrites) {
        long sIdx;
        long nIdx;
        long[] nums = new long[this.maxEvents];
        String[] strings = new String[this.maxEvents];
        SynchronizedMarkHolder synchronizedMarkHolder = this;
        synchronized (synchronizedMarkHolder) {
            System.arraycopy(this.nums, 0, nums, 0, this.maxEvents);
            System.arraycopy(this.strings, 0, strings, 0, this.maxEvents);
            nIdx = this.nIdx;
            sIdx = this.sIdx;
        }
        Long[] numsBoxed = new Long[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            numsBoxed[i] = nums[i];
        }
        Kyoo<Long> numQ = new Kyoo<Long>(numsBoxed, nIdx, (int)Math.min(nIdx, (long)this.maxEvents));
        Kyoo<String> stringQ = new Kyoo<String>(strings, sIdx, (int)Math.min(sIdx, (long)this.maxEvents));
        ArrayDeque<Mark> marks = new ArrayDeque<Mark>(this.maxEvents);
        while (!numQ.isEmpty()) {
            long genOp = numQ.remove();
            long gen = genOp & 0xFFFFFFFFFFFFFF00L;
            Mark.Operation op = Mark.Operation.valueOf((int)(genOp & 0xFFL));
            if (op.getNumbers() > numQ.size() || op.getStrings() > stringQ.size()) break;
            switch (op) {
                case TASK_START_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.taskStart(gen, n1, s1));
                    break;
                }
                case TASK_START_N1S2: {
                    long n1 = numQ.remove();
                    String s2 = stringQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.taskStart(gen, n1, s1, s2));
                    break;
                }
                case TASK_END_N1S0: {
                    long n1 = numQ.remove();
                    marks.addFirst(Mark.taskEnd(gen, n1));
                    break;
                }
                case TASK_END_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.taskEnd(gen, n1, s1));
                    break;
                }
                case TASK_END_N1S2: {
                    long n1 = numQ.remove();
                    String s2 = stringQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.taskEnd(gen, n1, s1, s2));
                    break;
                }
                case EVENT_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.event(gen, n1, s1));
                    break;
                }
                case EVENT_N1S2: {
                    long n1 = numQ.remove();
                    String s2 = stringQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.event(gen, n1, s1, s2));
                    break;
                }
                case EVENT_N2S2: {
                    long n2 = numQ.remove();
                    String s2 = stringQ.remove();
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.event(gen, n1, s1, s2, n2));
                    break;
                }
                case EVENT_N2S3: {
                    throw new UnsupportedOperationException();
                }
                case LINK: {
                    long n1 = numQ.remove();
                    marks.addFirst(Mark.link(gen, n1));
                    break;
                }
                case TAG_N0S1: {
                    throw new UnsupportedOperationException();
                }
                case TAG_N1S0: {
                    throw new UnsupportedOperationException();
                }
                case TAG_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.tag(gen, s1, n1));
                    break;
                }
                case TAG_KEYED_N0S2: {
                    String s2 = stringQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.keyedTag(gen, s1, s2));
                    break;
                }
                case TAG_KEYED_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.keyedTag(gen, s1, n1));
                    break;
                }
                case TAG_KEYED_N2S1: {
                    long n2 = numQ.remove();
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.keyedTag(gen, s1, n1, n2));
                    break;
                }
                case NONE: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return Collections.unmodifiableList(new ArrayList(marks));
    }

    @Override
    public int maxMarks() {
        return this.maxEvents;
    }

    private final class Kyoo<T>
    extends AbstractCollection<T>
    implements Queue<T> {
        private final T[] elements;
        private final long wIdx;
        private final int size;
        private int ri;

        Kyoo(T[] elements, long wIdx, int size) {
            this.elements = elements;
            this.wIdx = wIdx;
            this.size = size;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size - this.ri;
        }

        @Override
        public boolean offer(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove() {
            this.checkSize();
            return this.poll();
        }

        @Override
        public T poll() {
            if (this.size() == 0) {
                return null;
            }
            int rIdx = (int)(this.wIdx - 1L - (long)this.ri++ & SynchronizedMarkHolder.this.maxEventsMask);
            return this.elements[rIdx];
        }

        @Override
        public T element() {
            this.checkSize();
            return this.peek();
        }

        @Override
        public T peek() {
            if (this.size() == 0) {
                return null;
            }
            int rIdx = (int)(this.wIdx - 1L - (long)this.ri & SynchronizedMarkHolder.this.maxEventsMask);
            return this.elements[rIdx];
        }

        private void checkSize() {
            if (this.size() == 0) {
                throw new IllegalStateException();
            }
        }
    }
}

