/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import java.util.Arrays;
import javax.annotation.Nullable;

public final class Mark {
    public static final String NO_TAG_NAME = "";
    public static final long NO_TAG_ID = Long.MIN_VALUE;
    public static final long NO_LINK_ID = Long.MIN_VALUE;
    public static final long NO_NANOTIME = 0L;
    private static final long N0 = 0L;
    private static final String S0 = null;
    private final long generation;
    private final long n1;
    private final long n2;
    private final long n3;
    @Nullable
    private final String s1;
    @Nullable
    private final String s2;
    @Nullable
    private final String s3;
    private final Operation operation;

    public static Mark taskStart(long generation, long nanoTime, String name) {
        return new Mark(nanoTime, 0L, 0L, name, S0, S0, generation, Operation.TASK_START_N1S1);
    }

    public static Mark taskStart(long generation, long nanoTime, String name, String subName) {
        return new Mark(nanoTime, 0L, 0L, name, subName, S0, generation, Operation.TASK_START_N1S2);
    }

    public static Mark taskEnd(long generation, long nanoTime) {
        return new Mark(nanoTime, 0L, 0L, S0, S0, S0, generation, Operation.TASK_END_N1S0);
    }

    public static Mark taskEnd(long generation, long nanoTime, String name) {
        return new Mark(nanoTime, 0L, 0L, name, S0, S0, generation, Operation.TASK_END_N1S1);
    }

    public static Mark taskEnd(long generation, long nanoTime, String name, String subName) {
        return new Mark(nanoTime, 0L, 0L, name, subName, S0, generation, Operation.TASK_END_N1S2);
    }

    public static Mark event(long generation, long nanoTime, String name) {
        return new Mark(nanoTime, 0L, 0L, name, S0, S0, generation, Operation.EVENT_N1S1);
    }

    public static Mark event(long generation, long nanoTime, String name, String subName) {
        return new Mark(nanoTime, 0L, 0L, name, subName, S0, generation, Operation.EVENT_N1S2);
    }

    public static Mark event(long generation, long nanoTime, String taskName, String tagName, long tagId) {
        return new Mark(nanoTime, tagId, 0L, taskName, tagName, S0, generation, Operation.EVENT_N2S2);
    }

    public static Mark event(long generation, long nanoTime, String taskName, String subTaskName, String tagName, long tagId) {
        return new Mark(nanoTime, tagId, 0L, taskName, subTaskName, tagName, generation, Operation.EVENT_N2S3);
    }

    public static Mark tag(long generation, String tagName, long tagId) {
        return new Mark(tagId, 0L, 0L, tagName, S0, S0, generation, Operation.TAG_N1S1);
    }

    public static Mark tag(long generation, long tagId) {
        return new Mark(tagId, 0L, 0L, S0, S0, S0, generation, Operation.TAG_N1S0);
    }

    public static Mark tag(long generation, String tagName) {
        return new Mark(0L, 0L, 0L, tagName, S0, S0, generation, Operation.TAG_N0S1);
    }

    public static Mark keyedTag(long generation, String tagName, String value) {
        return new Mark(0L, 0L, 0L, tagName, value, S0, generation, Operation.TAG_KEYED_N0S2);
    }

    public static Mark keyedTag(long generation, String tagName, long value) {
        return new Mark(value, 0L, 0L, tagName, S0, S0, generation, Operation.TAG_KEYED_N1S1);
    }

    public static Mark keyedTag(long generation, String tagName, long value0, long value1) {
        return new Mark(value0, value1, 0L, tagName, S0, S0, generation, Operation.TAG_KEYED_N2S1);
    }

    public static Mark link(long generation, long linkId) {
        return new Mark(linkId, 0L, 0L, S0, S0, S0, generation, Operation.LINK);
    }

    public Mark withTaskName(String name) {
        switch (this.operation) {
            case EVENT_N1S1: 
            case TASK_END_N1S1: 
            case TASK_START_N1S1: {
                return new Mark(this.n1, this.n2, this.n3, name, this.s2, this.s3, this.generation, this.operation);
            }
            case TASK_START_N1S2: 
            case TASK_END_N1S0: 
            case NONE: 
            case TASK_END_N1S2: 
            case EVENT_N1S2: 
            case EVENT_N2S2: 
            case EVENT_N2S3: 
            case LINK: 
            case TAG_N0S1: 
            case TAG_N1S0: 
            case TAG_N1S1: 
            case TAG_KEYED_N1S1: 
            case TAG_KEYED_N2S1: 
            case TAG_KEYED_N0S2: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError();
    }

    private Mark(long n1, long n2, long n3, @Nullable String s1, @Nullable String s2, @Nullable String s3, long generation, Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        this.operation = operation;
        this.generation = generation;
        if (operation == Operation.NONE) {
            throw new IllegalArgumentException("bad operation");
        }
        this.n1 = n1;
        this.n2 = n2;
        this.n3 = n3;
        this.s1 = s1;
        this.s2 = s2;
        this.s3 = s3;
    }

    public long getNanoTime() {
        switch (this.operation.opType) {
            case TASK_START: 
            case TASK_END: 
            case EVENT: {
                return this.n1;
            }
            case NONE: 
            case LINK: 
            case TAG: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)this.operation.opType);
    }

    public long getGeneration() {
        return this.generation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getTagStringValue() {
        switch (this.operation) {
            case TAG_N0S1: 
            case TAG_N1S1: {
                return this.s1;
            }
            case EVENT_N2S2: 
            case TAG_KEYED_N0S2: {
                return this.s2;
            }
            case EVENT_N2S3: {
                return this.s3;
            }
            case EVENT_N1S1: 
            case TASK_END_N1S1: 
            case TASK_START_N1S1: 
            case TASK_START_N1S2: 
            case TASK_END_N1S0: 
            case NONE: 
            case TASK_END_N1S2: 
            case EVENT_N1S2: 
            case LINK: 
            case TAG_N1S0: 
            case TAG_KEYED_N1S1: 
            case TAG_KEYED_N2S1: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)this.operation.opType);
    }

    public long getTagFirstNumeric() {
        switch (this.operation) {
            case TAG_N1S0: 
            case TAG_N1S1: 
            case TAG_KEYED_N1S1: 
            case TAG_KEYED_N2S1: {
                return this.n1;
            }
            case EVENT_N2S2: 
            case EVENT_N2S3: {
                return this.n2;
            }
            case EVENT_N1S1: 
            case TASK_END_N1S1: 
            case TASK_START_N1S1: 
            case TASK_START_N1S2: 
            case TASK_END_N1S0: 
            case NONE: 
            case TASK_END_N1S2: 
            case EVENT_N1S2: 
            case LINK: 
            case TAG_N0S1: 
            case TAG_KEYED_N0S2: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)this.operation.opType);
    }

    public long getTagSecondNumeric() {
        switch (this.operation) {
            case TAG_KEYED_N2S1: {
                return this.n2;
            }
            case EVENT_N1S1: 
            case TASK_END_N1S1: 
            case TASK_START_N1S1: 
            case TASK_START_N1S2: 
            case TASK_END_N1S0: 
            case NONE: 
            case TASK_END_N1S2: 
            case EVENT_N1S2: 
            case EVENT_N2S2: 
            case EVENT_N2S3: 
            case LINK: 
            case TAG_N0S1: 
            case TAG_N1S0: 
            case TAG_N1S1: 
            case TAG_KEYED_N1S1: 
            case TAG_KEYED_N0S2: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)this.operation.opType);
    }

    public String getTagKey() {
        switch (this.operation) {
            case TAG_KEYED_N1S1: 
            case TAG_KEYED_N2S1: 
            case TAG_KEYED_N0S2: {
                return this.s1;
            }
            case EVENT_N1S1: 
            case TASK_END_N1S1: 
            case TASK_START_N1S1: 
            case TASK_START_N1S2: 
            case TASK_END_N1S0: 
            case NONE: 
            case TASK_END_N1S2: 
            case EVENT_N1S2: 
            case EVENT_N2S2: 
            case EVENT_N2S3: 
            case LINK: 
            case TAG_N0S1: 
            case TAG_N1S0: 
            case TAG_N1S1: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)this.operation.opType);
    }

    public String getTaskName() {
        switch (this.operation) {
            case EVENT_N1S1: 
            case TASK_END_N1S1: 
            case TASK_START_N1S1: 
            case TASK_START_N1S2: 
            case TASK_END_N1S2: 
            case EVENT_N1S2: 
            case EVENT_N2S2: 
            case EVENT_N2S3: {
                return this.s1;
            }
            case TASK_END_N1S0: 
            case NONE: 
            case LINK: 
            case TAG_N0S1: 
            case TAG_N1S0: 
            case TAG_N1S1: 
            case TAG_KEYED_N1S1: 
            case TAG_KEYED_N2S1: 
            case TAG_KEYED_N0S2: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)this.operation);
    }

    public String getSubTaskName() {
        switch (this.operation) {
            case TASK_START_N1S2: 
            case TASK_END_N1S2: 
            case EVENT_N1S2: 
            case EVENT_N2S3: {
                return this.s2;
            }
            case EVENT_N1S1: 
            case TASK_END_N1S1: 
            case TASK_START_N1S1: 
            case TASK_END_N1S0: 
            case NONE: 
            case EVENT_N2S2: 
            case LINK: 
            case TAG_N0S1: 
            case TAG_N1S0: 
            case TAG_N1S1: 
            case TAG_KEYED_N1S1: 
            case TAG_KEYED_N2S1: 
            case TAG_KEYED_N0S2: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)this.operation);
    }

    public long getLinkId() {
        switch (this.operation.opType) {
            case LINK: {
                return this.n1;
            }
            case TASK_START: 
            case TASK_END: 
            case EVENT: 
            case NONE: 
            case TAG: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)this.operation.opType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Mark)) {
            return false;
        }
        Mark that = (Mark)obj;
        return Mark.equal(this.s1, that.s1) && Mark.equal(this.s2, that.s2) && Mark.equal(this.s3, that.s3) && this.n1 == that.n1 && this.n2 == that.n2 && this.n3 == that.n3 && this.operation == that.operation && this.generation == that.generation;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.operation, this.s1, this.s2, this.s3, this.n1, this.n2, this.n3, this.generation});
    }

    public String toString() {
        return "Mark{operation=" + (Object)((Object)this.operation) + ", s1=" + this.s1 + ", s2=" + this.s2 + ", s3=" + this.s3 + ", n1=" + this.n1 + ", n2=" + this.n2 + ", n3=" + this.n3 + ", generation=" + this.generation + "}";
    }

    static <T> boolean equal(T a, T b) {
        return a == b || a.equals(b);
    }

    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation NONE = new Operation(OperationType.NONE, 0, 0);
        public static final /* enum */ Operation TASK_START_N1S1 = new Operation(OperationType.TASK_START, 1, 1);
        public static final /* enum */ Operation TASK_START_N1S2 = new Operation(OperationType.TASK_START, 1, 2);
        public static final /* enum */ Operation TASK_END_N1S0 = new Operation(OperationType.TASK_END, 1, 0);
        public static final /* enum */ Operation TASK_END_N1S1 = new Operation(OperationType.TASK_END, 1, 1);
        public static final /* enum */ Operation TASK_END_N1S2 = new Operation(OperationType.TASK_END, 1, 2);
        public static final /* enum */ Operation EVENT_N1S1 = new Operation(OperationType.EVENT, 1, 1);
        public static final /* enum */ Operation EVENT_N1S2 = new Operation(OperationType.EVENT, 1, 2);
        public static final /* enum */ Operation EVENT_N2S2 = new Operation(OperationType.EVENT, 2, 2);
        public static final /* enum */ Operation EVENT_N2S3 = new Operation(OperationType.EVENT, 2, 3);
        public static final /* enum */ Operation LINK = new Operation(OperationType.LINK, 1, 0);
        public static final /* enum */ Operation TAG_N0S1 = new Operation(OperationType.TAG, 0, 1);
        public static final /* enum */ Operation TAG_N1S0 = new Operation(OperationType.TAG, 1, 0);
        public static final /* enum */ Operation TAG_N1S1 = new Operation(OperationType.TAG, 1, 1);
        public static final /* enum */ Operation TAG_KEYED_N1S1 = new Operation(OperationType.TAG, 1, 1);
        public static final /* enum */ Operation TAG_KEYED_N2S1 = new Operation(OperationType.TAG, 2, 1);
        public static final /* enum */ Operation TAG_KEYED_N0S2 = new Operation(OperationType.TAG, 0, 2);
        private final OperationType opType;
        private final int longs;
        private final int strings;
        private static final Operation[] values;
        private static final /* synthetic */ Operation[] $VALUES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String name) {
            return Enum.valueOf(Operation.class, name);
        }

        private Operation(OperationType opType, int longs, int strings) {
            this.opType = opType;
            this.longs = longs;
            this.strings = strings;
            assert (longs <= Operation.maxNumbers());
            assert (strings <= Operation.maxStrings());
        }

        public OperationType getOpType() {
            return this.opType;
        }

        public int getNumbers() {
            return this.longs;
        }

        public int getStrings() {
            return this.strings;
        }

        public static int maxNumbers() {
            return 2;
        }

        public static int maxStrings() {
            return 3;
        }

        public static int maxMarkers() {
            return 1;
        }

        public static Operation valueOf(int code) {
            return values[code];
        }

        static {
            $VALUES = new Operation[]{NONE, TASK_START_N1S1, TASK_START_N1S2, TASK_END_N1S0, TASK_END_N1S1, TASK_END_N1S2, EVENT_N1S1, EVENT_N1S2, EVENT_N2S2, EVENT_N2S3, LINK, TAG_N0S1, TAG_N1S0, TAG_N1S1, TAG_KEYED_N1S1, TAG_KEYED_N2S1, TAG_KEYED_N0S2};
            values = Operation.values();
            assert (values.length <= 256);
        }
    }

    public static enum OperationType {
        NONE,
        TASK_START,
        TASK_END,
        EVENT,
        LINK,
        TAG;

    }
}

